<?php
use App\Location;
use App\Validate;

checkDemoMode();
checkAccess('LOCATION_MANAGE');
checkUserCountry();

$rules = [
    'title' => ['name' => 'نام', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 2, 'max' => 200]
];

$state_id = $city_id = 0;
$type = 'state';

if (inputs()->not_empty('state_id')) {
    $type = 'city';
    $state_id = input('state_id');
}

$Location = new Location($type);
$slug = slug(input('title'));
if (inputs()->not_empty('slug')) {
    $slug = slug(input('slug'));
}

$validate = new Validate();
if (empty($slug)) {
    $validate->addError('نامک وارد شده معتبر نمی باشد');
}

$validation = $validate->check($_POST, $rules);
if ($validation->passed()) {
    try {
        $Location->insert(input('title'), $slug, $state_id, $city_id, input('latitude'), input('longitude'));

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
    }
} else {
    session()->error($validation->errors(), true);
}
