<?php

use App\Coupon;
use App\Validate;

checkDemoMode();

$validation = new Validate();
/** @var Validate $validation */
/** @var Coupon $coupon */
$validation = $validation->check(inputs()->all(), $coupon->rules(true));

$_POST['discount'] = (int) money_to_num(input('discount'));
if (input('type') === 'cart-percent'&& ((input('discount') > 99 || input('discount') < 1))) {
    $validation->addError('درصد تخفیف وارد شده معتبر نیست');
}

if ($validation->passed()) {
    try {
        $coupon->revise(inputs()->all());

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        // dd($e->getMessage());
        session()->error();
    }
} else {
    session()->error($validation->errors(), true);
}