<?php

use App\Banner;
use App\ImageUpload;

checkDemoMode();
checkUserCountry();

if (! isPost() || ! token()->check()) {
    session()->alert('error', _e('WRONG_CSRF_TOKEN', true));
    redirect('refer');
}

$Banner = new Banner();
$banner = $Banner->byId(input('id'));

if (! $banner) {
    abort(404);
}

$banner->update(inputs()->all());

if (! inputs()->isFileUploaded('imageUpload')) {
    session()->success();
    redirect('refer');
}

$banners_root = '../images/banner_images/';
$adm_options = generalSettings();
$image = new ImageUpload();

$image->uploadName = "imageUpload";
$image->imgRoot = $banners_root;
$image->addWatermark = false;
$image->resize = true;
$image->renameIteration = false;
$image->maxSizeKB = $adm_options->MAX_SLIDER_SIZE_KB;
$image->widthMain = $banner->WIDTH;
$image->heightMain = $banner->HEIGHT;
$image->validFormats = ['jpg', 'jpeg', 'JPG', "JPEG", 'gif', 'GIF'];
$image->validMimeTypes = ['image/jpeg', 'image/gif'];
$image->ajaxUpload = false;
$image->autoNaming = true;
$image->makeThumb = false;
$image->isBanner = true;

if ($image->make()) {
    if (file_exists($banner->imagePath())) {
        unlink($banner->imagePath());
    }

    $banner->updateImage($image->getFileName());

    session()->success();
    redirect('refer');
} else {
    session()->error($image->getError());
    redirect('refer');
}
