<?php

use App\Banner;
use App\Validate;

checkDemoMode();

if (! token()->check()) {
    redirect('refer');
}

$validation = new Validate();
$rules = [
    'WIDTH' => [
        'name' => 'عرض',
        'prefix' => _e('ENTERING', true),
        'required' => 'true'
    ],
    'HEIGHT' => [
        'name' => 'ارتفاع',
        'prefix' => _e('ENTERING', true),
        'required' => 'true'
    ]
];

/** @var Validate $validation */
$validation = $validation->check($_POST, $rules);
if (! $validation->passed()) {
    session()->error($validation->errors());
    redirect('refer');
}

try {
    $Banner = new Banner();
    $Banner->createNew('AFFILIATE', input('WIDTH'), input('HEIGHT'));

    session()->success();
    redirect('refer');
} catch (PDOException $e) {
    session()->error();
    redirect('refer');
}