<?php

use App\Banner;
use App\Validate;

checkDemoMode();

$validation = new Validate();
$rules = [
    'WIDTH' => [
        'name' => 'عرض',
        'prefix' => _e('ENTERING', true),
        'required' => 'true'
    ],
    'HEIGHT' => [
        'name' => 'ارتفاع',
        'prefix' => _e('ENTERING', true),
        'required' => 'true'
    ]
];

/** @var Validate $validation */
$validation = $validation->check($_POST, $rules);
if (! $validation->passed()) {
    session()->error($validation->errors(), true);
    redirect('refer');
}

try {
    $category_id = (inputs()->not_any('category')) ? input('category') : 0;
    $subcategory_id = (inputs()->not_any('subcategory')) ? input('subcategory') : 0;
    $subsidiary_id = (inputs()->not_any('subsidiary')) ? input('subsidiary') : 0;
    $position = (input('WIDTH') === "SIDEBAR") ? "SIDEBAR" : "CONTENT";
    $width = (input('WIDTH') === "SIDEBAR") ? 260 : input('WIDTH');
    $height = input('HEIGHT');

    $Banner = new Banner();
    $Banner->createNew($position, $width, $height, $category_id, $subcategory_id, $subsidiary_id);

    session()->success('بنر جدید با موفقیت ایجاد شد.');
    redirect('refer');
} catch (PDOException $e) {
    session()->error('مشکلی در عملیات ایجاد بنر به وجود آمده است');
    redirect('refer');
}