<?php
use Admin\Ads;

use Admin\User;
use App\Affiliate;
use App\CustomFields;
use App\Order;
use App\Plan;
use App\Shamsi;
use App\SubCategory;
use App\WithdrawalRequest;
use Carbon\Carbon;

require_once '../init.php';
require_once '../check_auth.php';

checkUserCountry();

if (inputs()->not_empty('stateId') && !inputs()->not_empty('action')) {
    $cities = Ads::cities(input('stateId'));
    $cityOptions = "<option value='0' selected disabled style='display: none;'> انتخاب کنید </option>";
    foreach ($cities as $city) {
        $cityOptions .= "<option value='{$city->CITY_ID}'>{$city->CITY_NAME}</option>";
    }

    echo $cityOptions;
}

if (inputs()->not_empty('cityId') && !inputs()->not_empty('action')) {
    $stmt = $db->prepare("SELECT * FROM tbl_zones WHERE CITY_ID=?");
    $stmt->execute(array($_GET['cityId']));
    $stmt = $stmt->fetchAll(PDO::FETCH_BOTH);
    $zoneOptions = "<option value='0' selected disabled style='display: none;'> انتخاب کنید </option>";
    foreach ($stmt as $zone) {
        $zoneOptions .= "<option value=" . $zone['ID'] . ">" . $zone['ZONE_NAME'] . "</option>";
    }
    echo $zoneOptions;
}

if (inputs()->not_empty('planId') && inputs()->not_empty('fromDate') && inputs()->not_empty('adsId')) {
    $Ads = new Ads();
    $Plan = new Plan();
    $Shamsi = new Shamsi();

    $ads = $Ads->ads_by_id(input('adsId'), false);
    $plan = $Plan->byId(input('planId'));

    $from_date_carbon = convertPersianDatePickerResult(input('fromDate'), true);

    if (input('planId') != $ads->PLAN_ID) {
        // if plan changed ...
        $to_date = $from_date_carbon->addDays($plan->PLAN_DAYS)->format('Y-m-d H:i:s');

    } elseif (input('planId') == $ads->PLAN_ID && input('fromDate') != $ads->FROM_DATE) {

        $to_date1 = Carbon::parse($ads->TO_DATE)->format('Y-m-d H:i:s');
        $to_date2 = $from_date_carbon->addDays($plan->PLAN_DAYS)->format('Y-m-d H:i:s');
        $to_date3 = $ads->TO_DATE;

        $to_date = max($to_date1, $to_date2, $to_date3);
    }

    $to_date = miladiToShamsiAdmin($to_date, 'Y/m/d ساعت H:i');

    return ajaxSuccessResponse(['message' => $to_date]);
}

if (input('action') === 'fetch-withdrawal-details') {
    $requestId = input('requestId');

    $Affiliate = new Affiliate();
    $WithdrawalRequest = new WithdrawalRequest();
    $request = $WithdrawalRequest->findById($requestId);

    $affiliate_ids = json_decode($request->referal_ids);

    if ($affiliate_ids) {
        $affiliates = $Affiliate->byArrayOfIdsSimple($affiliate_ids, 'id');

        foreach ($affiliates AS $affiliate) {
            /* @var Affiliate $affiliate */
            echo
                "<tr>
                    <td>" . $affiliate->comment . "</a></td>
                    <td>" . number_format($affiliate->price) . "</td>
                    <td>" . number_format($affiliate->commision) . "</td>
                    <td>" . $affiliate->user_id . "</td>
                    <td>" . miladiToShamsiAdmin($affiliate->date_created, "Y/m/d") . "</td>
                    <td> " . $affiliate->showStatus() . "</td>
                </tr>
            ";
        }
    }
}

if (input('action') === 'calculate-income-report') {
    try {
        $Order = new Order();
        $income = $Order->reportByRangeShamsi(input('from_date'), input('to_date'));

        return ajaxSuccessResponse([
            'income' => price_format($income)
        ]);
    } catch (Exception $e) {
        return ajaxErrorResponse("تاریخ های ارسالی معتبر نمی باشند");
    }



}

if (isset($_GET['userId']) && !empty ($_GET['userId'])) {
    $userId = $_GET['userId'];
    $User = new User();
    $user = $User->user_by_id($userId);
    echo "
		<h4>
			شناسه کاربر : <span class='foreign'>{$user->USER_ID}</span> <br/><br/>
			نام کاربری : <span class='foreign'>{$user->username()}</span> <br/><br/>
			نام : {$user->NAME} <br/><br/>
			شماره کارت بانکی : <span class='foreign'>{$user->CREDIT_CARD} </span>
		</h4>
	";
}
if (isset($_GET['categoryId']) && !empty ($_GET['categoryId'])) {
    $catId = $_GET['categoryId'];
    $Ads = new Ads();
    $parents = $Ads->parentSubcategories($catId);
    echo "<option value='0'> انتخاب کنید </option>";
    if ($parents) {
        foreach ($parents AS $parent) {
            echo "<option value='{$parent->SUBCAT_ID}'> {$parent->SUBCATEGORY_NAME} </option>";
        }
    }
}

/*------------------------------------------------
* Ajax Results after Selecting category in search
--------------------------------------------------*/
if (inputs()->not_empty('catId') && input('action') === "find-subcategory-for-search") {
    $output['status'] = false;
    $output['result'] = "";

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $catId = input('catId');

    if (input('catId') != 'any') {
        $Ads = new Ads();
        $subcategories = $Ads->parentSubcategories($catId);

        if ($subcategories) {
            $output['status'] = true;
            $output['result'] = "<option value='any' selected disabled style='display: none;'>انتخاب کنید</option>";
            foreach ($subcategories AS $subcategory) {
                $output['result'] .= "<option value={$subcategory->SUBCAT_ID}>{$subcategory->SUBCATEGORY_NAME}</option>";
            }
        } else {

            $CustomFields = new CustomFields();
            $custom_fields = $CustomFields->getFieldsForCategory($catId);

            if ($custom_fields) {
                $output['custom_field_status'] = true;

                /** @var App\CustomFields $field */
                foreach ($custom_fields as $field) {
                    $output['custom_field_result'] .= $field->show('edit', true);
                    $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
                }
            }

        }
    }

    echo json_encode($output);
}

/*------------------------------------------------
* Ajax Results after Selecting subcategory in search
--------------------------------------------------*/
if (inputs()->not_empty('subcatId') && inputs()->not_empty('subcatId') && input('action') === "find-subsidiary-for-search") {
    $output['status'] = false;
    $output['result'] = "";

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $catId = input('catId');
    $subcatId = input('subcatId');

    if (input('subcatId') != 'any') {

        $Ads = new Ads();
        $subcategories = $Ads->subcategory_Subsidiaries($subcatId);

        if ($subcategories) {
            $output['status'] = true;
            $output['result'] = "<option value='any' selected disabled style='display: none;'>انتخاب کنید</option>";
            foreach ($subcategories AS $subcategory) {
                $output['result'] .= "<option value={$subcategory->SUBCAT_ID}>{$subcategory->SUBCATEGORY_NAME}</option>";
            }

        } else {

            $CustomFields = new CustomFields();
            $custom_fields = $CustomFields->getFieldsForSubcategory($catId, $subcatId);

            if ($custom_fields) {
                $output['custom_field_status'] = true;

                /** @var App\CustomFields $field */
                foreach ($custom_fields as $field) {
                    $output['custom_field_result'] .= $field->show('edit', true);
                    $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
                }
            }
        }
    }

    echo json_encode($output);
}

/*--------------------------------------------------
* Ajax Results after Selecting subsidiary in search
----------------------------------------------------*/
if (inputs()->not_empty('subsidiaryId') && input('action') === "find-final-result-for-search") {

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $catId = input('catId');
    $subcatId = input('subcatId');
    $subsidiaryId = input('subsidiaryId');

    $CustomFields = new CustomFields();

    $custom_fields = false;
    if ($subsidiaryId != 'any') {
        $custom_fields = $CustomFields->getFieldsForSubsidiary($catId, $subcatId, $subsidiaryId);
    }

    if ($custom_fields) {
        $output['custom_field_status'] = true;
        foreach ($custom_fields as $field) {
            $output['custom_field_result'] .= $field->show('edit', true);
            $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
        }
    }

    echo json_encode($output);
}


/*------------------------------------------------
* Ajax Results after Selecting category in search IN Banners Section
--------------------------------------------------*/
if (inputs()->not_empty('catId') && input('action') === "find-subcategory-for-search-in-banners") {
    $output['status'] = false;
    $output['result'] = "";

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $catId = input('catId');

    if (input('catId') != 'any') {
        $Ads = new Ads();
        $subcategories = $Ads->parentSubcategories($catId);

        if ($subcategories) {
            $output['status'] = true;
            $output['result'] = "<option value='any'>بدون زیردسته</option>";
            foreach ($subcategories AS $subcategory) {
                $output['result'] .= "<option value={$subcategory->SUBCAT_ID}>{$subcategory->SUBCATEGORY_NAME}</option>";
            }
        }
    }

    echo json_encode($output);
}

/*------------------------------------------------
* Ajax Results after Selecting subcategory in search IN Banners Section
--------------------------------------------------*/
if (inputs()->not_empty('subcatId') && inputs()->not_empty('subcatId') && input('action') === "find-subsidiary-for-search-in-banners") {
    $output['status'] = false;
    $output['result'] = "";

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";

    $catId = input('catId');
    $subcatId = input('subcatId');

    if (input('subcatId') != 'any') {

        $Ads = new Ads();
        $subcategories = $Ads->subcategory_Subsidiaries($subcatId);

        if ($subcategories) {
            $output['status'] = true;
            $output['result'] = "<option value='any' selected disabled style='display: none;'>بدون زیردسته</option>";
            foreach ($subcategories AS $subcategory) {
                $output['result'] .= "<option value={$subcategory->SUBCAT_ID}>{$subcategory->SUBCATEGORY_NAME}</option>";
            }

        }
    }

    echo json_encode($output);
}

if (input('action') === 'remote-load-users') {

    $users = User::byKeyword(input('keyword'));

    $output = [];
    /** @var Admin\User $user */
    foreach ($users as $user) {
        $image = "../images/users_images/{$user->USER_ID}/1.jpg";
        if (!file_exists('../' . $image)) {
            $image = "../images/users_images/default.png";
        }

        $item = [
            "id" => $user->ID,
            "title" => $user->publicName() . ' - ' . $user->roleName(),
            "image" => $image,
            "meta1" => "<span class='icon-user'></span> " . $user->username(),
            "meta2" => "<span class='icon-envelope'></span> " . $user->EMAIL,
            "meta3" => "<span class='icon-phone'></span> " . $user->TEL,
        ];

        if (input('type') === 'minimal') {
            $item = [
                "id" => $user->ID,
                "title" => $user->username(),
            ];
        }

        $output['items'][] = $item;
    }

    echo json_encode($output, JSON_UNESCAPED_UNICODE);
}

/**
 * Returns the parent subcategories for the requested category_id
 */
if (input('action') === 'parent-subcategories') {
    $category_id = input('category_id');

    $SubCategory = new SubCategory();
    $subcategories = $SubCategory->firstTireForCategory($category_id);

    $output = "<option value='0'> انتخاب کنید </option>";
    if ($subcategories) {
        foreach ($subcategories AS $subcategory) {
            $output .= "<option value='{$subcategory->ID}'> {$subcategory->SUBCATEGORY_NAME} </option>";
        }
    }

    return ajaxSuccessResponse(['html' => $output]);
}

















/*-------------------------------------------------------------------
* Ajax Results after Selecting category for custom field edit page
--------------------------------------------------------------------*/
if (inputs()->not_empty('catId') && input('action') === "find-subcategory-for-custom-fields-page") {
    $output['result'] = "";

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";
    $output['custom_field_count'] = 0;

    $catId = input('catId');

    if (input('catId') != 'any') {
        $Ads = new Ads();
        $subcategories = $Ads->parentSubcategories($catId);

        if ($subcategories) {
            $output['result'] = "<option value='any' selected disabled style='display: none;'>انتخاب کنید</option>";
            foreach ($subcategories AS $subcategory) {
                $output['result'] .= "<option value={$subcategory->SUBCAT_ID}>{$subcategory->SUBCATEGORY_NAME}</option>";
            }

            $CustomFields = new CustomFields();
            $custom_fields = $CustomFields->getFieldsForCategory($catId);

            if ($custom_fields) {
                $output['custom_field_status'] = true;
                $output['custom_field_count'] = count($custom_fields);

                /** @var App\CustomFields $field */
                foreach ($custom_fields as $field) {
                    $output['custom_field_result'] .= $field->show('edit', true);
                    $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
                }
            }

            return ajaxSuccessResponse($output);
        }
    }

    return ajaxErrorResponse();
}


/*-------------------------------------------------------------------
* Ajax Results after Selecting subcategory for custom field edit page
--------------------------------------------------------------------*/
if (inputs()->not_empty('subcatId') && inputs()->not_empty('subcatId') && input('action') === "find-subsidiary-for-custom-fields-page") {
    $output['result'] = "";

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";
    $output['custom_field_count'] = 0;

    $catId = input('catId');
    $subcatId = input('subcatId');

    if (input('subcatId') != 'any') {
        $Ads = new Ads();
        $subcategories = $Ads->subcategory_Subsidiaries($subcatId);

        if ($subcategories) {
            $output['result'] = "<option value='any' selected disabled style='display: none;'>انتخاب کنید</option>";
            foreach ($subcategories AS $subcategory) {
                $output['result'] .= "<option value={$subcategory->SUBCAT_ID}>{$subcategory->SUBCATEGORY_NAME}</option>";
            }

            $CustomFields = new CustomFields();
            $custom_fields = $CustomFields->getFieldsForSubcategorySpecific($catId, $subcatId);

            if ($custom_fields) {
                $output['custom_field_status'] = true;
                $output['custom_field_count'] = count($custom_fields);

                /** @var App\CustomFields $field */
                foreach ($custom_fields as $field) {
                    $output['custom_field_result'] .= $field->show('edit', true);
                    $output['custom_field_result'] .= '<script>price_field_remover("price");price_field_remover("mortgage");price_field_remover("rent");</script>';
                }
            }

            return ajaxSuccessResponse($output);
        }
    }

    return ajaxErrorResponse();
}

/*------------------------------------------------------------------
* Ajax Results after Selecting subsidiary for custom field edit page
-------------------------------------------------------------------*/
if (inputs()->not_empty('subsidiaryId') && input('action') === "find-final-result-for-custom-fields-page") {

    $output['custom_field_status'] = false;
    $output['custom_field_result'] = "";
    $output['custom_field_count'] = 0;

    $catId = input('catId');
    $subsidiaryId = input('subsidiaryId');

    $CustomFields = new CustomFields();

    $custom_fields = false;
    if ($subsidiaryId != 'any') {
        $custom_fields = $CustomFields->getFieldsForSubcategorySpecific($catId, $subsidiaryId);
    }

    if ($custom_fields) {
        $output['custom_field_status'] = true;
        $output['custom_field_count'] = count($custom_fields);

        foreach ($custom_fields as $field) {
            $output['custom_field_result'] .= $field->show('edit', true);
        }
    }

    return ajaxSuccessResponse($output);
}