<?php

use Admin\Ads;
use App\Plan;

checkDemoMode();


$action = input('action');

$checked = input('selected_values');
if (count($checked) == 0) {
    redirect('refer');
}

/**
 *
 * Accept and activate multiple ads simultaneously
 *
 */
if ($action === 'accept') {
    try {

        $is_active = $is_shown = 2;
        $is_rejected = $is_expired = $is_edited = $is_deleted = 1;

        $Ads = new Ads();
        $adss = $Ads->byArrayOfIds($checked);
        $adss = $Ads->eagerLoad('special.plan', $adss);

        $Plan = new Plan();

        /** @var Ads $ads */
        foreach ($adss as $ads) {
            $is_paid = ($ads->is_free()) ? 1 : 2;

            
            $new_plan = $Plan->byId($ads->special()->ADS_TYPE);
            $to_date = n_days_later(now(), $new_plan->PLAN_DAYS);

           

            $ads->updateStatus($is_active, $is_edited, $is_deleted);
            $ads->special()->updateStatus($is_paid, $is_shown, $is_rejected, $is_expired);
            $ads->special()->updateExpiryDate($to_date);

            if ($ads->is_expired()) {
                $ads->special()->activateExpiredItem();
            }

            if ($ads->has_telegram() && ! $ads->isTelegramed()) {
                $featured_image = $ads->featuredImage('main', false);
                $ads->sendToTelegram($ads->ADS_TITLE, $featured_image);
            }
        }

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}


/**
 *
 * Set is_paid status to paid for multiple ads simultaneously
 *
 */
if ($action === 'paid') {
    checkDemoMode();

    try {

        $Ads = new Ads();
        $adss = $Ads->byArrayOfIds($checked);
        $adss = $Ads->eagerLoad('special.plan', $adss);

        foreach ($adss as $ads) {
            if ($ads->is_free()) {
                continue;
            }

            $ads->special()->makePaid();
        }

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}

/**
 *
 * Reject multiple ads simultaneously
 *
 */
if ($action === 'reject') {
    checkDemoMode();

    try {
        $Ads = new Ads();
        $adss = $Ads->byArrayOfIds($checked);

        /** @var Ads $ads */
        foreach ($adss as $ads) {
            $ads->make_rejected();
            $ads->makeUnEdited();
        }

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}

/**
 *
 * Deletes Multiple Ads simultaneously
 *
 */
if ($action === 'delete') {
    checkDemoMode();
    checkAccess('ADS_DELETE');

    try {
        $Ads = new Ads();
        $Ads->bulkDelete($checked);

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}