<?php
use App\CustomFieldOptions;
use App\CustomFields;

if (isDemoMode()) {
    return ajaxErrorResponse('امکان استفاده از این قسمت در نسخه دموی سایت وجود ندارد');
}

$fields = json_decode(input('data'));
$CustomFieldOption = new CustomFieldOptions();

$subcategory_id = ! empty($subcategory->ID) ? $subcategory->ID : 0;

foreach($fields as $field_data) {
    /**
     * Check if a field with given id (hidden description field) already exists in database
     */
    $found = array_filter($custom_fields, function($item) use ($field_data) {
        return ($item->id == $field_data->description);
    });

    /**
     * Update current fields or create new ones
     */
    if (count($found) > 0) {
        /** @var CustomFields $found_custom_field */
        $item_index = array_keys($found)[0];
        $found_custom_field = array_shift($found);

        $found_custom_field->update($field_data);
        unset($custom_fields[$item_index]);
        $custom_field_id = $found_custom_field->id;
    } else {
        $custom_field_id = $CustomField->create($field_data, $category->ID, $subcategory_id);
        $field_data->description = $custom_field_id;
    }

    /**
     * Save Sort For Options
     */
    $sort_array = [];
    if (isset($field_data->values)) {
        $custom_field_options = $CustomFieldOption->byFieldId($custom_field_id);

        $i = 1;
        foreach ($field_data->values as $option) {
            $found = array_filter($custom_field_options, function($item) use ($option) {
               return $item->option_key == $option->value;
            });

            $found_option = array_shift($found);

            $sort_array[] = [
                'option_id' => $found_option->id,
                'sort' => $i
            ];

            $i++;
        }

        $CustomFieldOption->saveSort($sort_array);
    }

}

/**
 * Delete Redundant custom fields
 *
 * @var CustomFields $custom_field
 */
foreach ($custom_fields as $custom_field) {
    $custom_field->delete();
}


/**
 * Save Sort For Custom Fields
 */
if (count($fields) > 0) {
    $custom_fields = $CustomField->getFieldsForBuilder($category->ID, $subcategory_id);
    $sort_array = [];
    $i = 1;
    foreach ($fields as $field_data) {
        $sort_array[] = [
            'field_id' => $field_data->description,
            'label' => $field_data->label,
            'sort' => $i
        ];

        $i++;
    }
    $CustomField->saveSort($sort_array);
}

return ajaxSuccessResponse(['html' => _e('OPERATION_SUCCESS', true)]);