<?php
use App\Session;
use App\Validate;

if (token()->check() && isPost() ) {

    $validation = new Validate();
    $rules = [
        'frm_title' => [
            'name' => _e('TITLE', true),
            'prefix' => _e('ENTERING', true),
            'required' => true,
            'min' => 2,
            'max'=> 200
        ],
    ];

    $validation = $validation->check($_POST, $rules);
    if ($validation->passed()) {

        try {
            $Plan->createNew(inputs()->all());

            session()->success();
            redirect(plansRoute());
        } catch(PDOException $e) {
            session()->error();
        }
    } else {
        session()->error($validation->errors(), true);
    }

} else {
    session()->error(_e('WRONG_CSRF_TOKEN', true));
}
