<?php
use Admin\Ads;

use App\Input;
use App\Location;
use App\Session;
use App\Validate;

checkDemoMode();
checkAccess('LOCATION_MANAGE');
checkUserCountry();

$validate = new Validate();
$Ads = new Ads();

$rules = [
    'title' => ['name' => 'نام', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 2, 'max'=> 200 ],
    'slug'  => ['name' => 'نامک', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 2, 'max'=> 200 ]
];

$state_id = $city_id = 0;
$type = null;

$type = 'state';
if (! inputs()->not_empty('city_id') && inputs()->not_empty('state_id')) {
    $type = 'city';
    $state_id = input('state_id');
}

$Location = new Location($type);
$slug = slug(input('slug'));
$slug = $Location->slug($slug, $location->id());

if (empty($slug)) {
    $validate->addError('نامک وارد شده معتبر نمی باشد');
}

$validation = $validate->check($_POST, $rules);
if ($validation->passed()) {
    try {
        /**
         * Location type didn't change
         */
        if ($location->isOfType($type)) {
            $location->update(input('title'), $slug, $state_id, $city_id, input('latitude'), input('longitude'));
            session()->success();
            redirect(locationsRoute($type));
        }

        /**
         * If Location type changed
         */
        $Location->insert(input('title'), $slug, $state_id, $city_id, input('latitude'), input('longitude'));
        $location->delete();

        session()->success('ویرایش با موفقیت انجام شد');
        redirect(locationsRoute($type));
    } catch (PDOException $e) {
        session()->error();
    }
} else {
    session()->error($validation->errors(), true);
}
