<?php
use Admin\Ads;
use App\Input;
use App\Location;
use App\Session;
use App\Validate;

checkDemoMode();
checkAccess('LOCATION_MANAGE');
checkUserCountry();

$validate = new Validate();
$Ads = new Ads();

$rules = [
    'title' => ['name' => 'نام', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 2, 'max' => 200],
    'slug' => ['name' => 'نامک', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 2, 'max' => 200]
];

$state_id = $city_id = 0;
$type = 'state';
if (inputs()->not_empty('state_id')) {
    $type = 'city';
    $state_id = input('state_id');
}

$Location = new Location($type);
$slug = $Location->slug(slug(input('slug')));

if (empty($slug)) {
    $validate->addError('نامک وارد شده معتبر نمی باشد');
}

$validation = $validate->check($_POST, $rules);
if ($validation->passed()) {
    try {
        $Location->insert(input('title'), $slug, $state_id, $city_id, input('latitude'), input('longitude'));

        session()->success('ثبت با موفقیت انجام شد');
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
    }
} else {
    session()->error($validation->errors(), true);
}
