<?php

use App\Post;
use App\Tag;

include 'init.php';
$page_slug = 'posts-edit';
include 'check_auth.php';

$page__has_maps = true;

$Tags = new Tag();
$Posts = new Post();

$post = $Posts->byId(input('id'));
if (! $post) {
    abort();
}

$ads_images = $post->images('thumb', true, false);

$ads_images_count = ($ads_images) ? count($ads_images) : 0;

// count of image placeholders at start
$start_images_count = 6;
if (fmod($ads_images_count, 3) != 0) {
    $start_images_count = $ads_images_count + (3 - fmod($ads_images_count, 3));
}
if ($start_images_count < 6) {
    $start_images_count = 6;
}

for ($i = 1; $i <= $start_images_count; $i++) {
    $preuploaded_images_names[] = [
        'id' => $i,
        'name' => removeExtension(basename(removeSizeFromImageName($ads_images[$i - 1])))
    ];
}

if (isPost() && token()->check()) {
    include('process/posts/update.php');
}

$top_menus = [
    [
        'icon' => 'flaticon-eye',
        'title' => 'مشاهده مطلب',
        'link' => $post->viewLink(),
    ]
]
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/persianDatepicker/css/persianDatepicker-default.css"/>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="submit-item-form">

                            <!--begin::Portlet-->
                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= adsRoute() ?>"
                                               class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                بازگشت
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" name="submit_item" id="submit_item"
                                                        class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                    <i class="la la-check"></i>
                                                    ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-7">
                                    <?php include('includes/posts/edit/_main_fields.php') ?>
                                </div>
                                <div class="col-lg-5">
                                    <?php
                                    include('includes/posts/edit/_status_widgets.php');

                                    include('includes/edit_ads/_upload_images.php');

                                    include('includes/posts/edit/_votes.php');
                                    ?>
                                </div>
                            </div>

                        </form>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
<?php include 'includes/_validate_js_variables.php' ?>

<script>
    var images_count = "<?php echo $start_images_count ?>";
    var preuploaded_images_count = "<?php echo $ads_images_count; ?>";
    var preuploaded_images_names = <?php echo json_encode($preuploaded_images_names); ?>;

    var form_upload_url = "../process/pr_ajax_upload_post.php";
</script>

<!-- plugins -->
<script type="text/javascript" src="vendors/ckeditor/ckeditor.js"></script>
<script type="text/javascript" src="../public/lib/simple-ajax-uploader/SimpleAjaxUploader.min.js"></script>

<!-- scripts -->
<script src="assets/app/js/custom/pages/upload_edit.js"></script>
<script src="assets/app/js/custom/pages/validate_post.js"></script>
<script src="vendors/ckeditor/ckeditor.js"></script>

<script>
    startCKEditor('frm_text', true);
    initiateSelect2();
    initiateSelect2Tags();
</script>
</body>
</html>

