<?php

include 'init.php';

$page_slug = 'posts-categories--create';
include 'check_auth.php';


if (isPost() && token()->check()) {
    include('process/posts/categories/_insert.php');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/bootstrap-colorpicker/dist/bootstrap-colorpicker.css">
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="submit-item-form">

                            <?= csrf_field() ?>

                            <!--begin::Portlet-->
                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile" >
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= postCategoriesRoute() ?>" class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                انصراف
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" name="submit_item" id="submit_item" class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                        <i class="la la-check"></i>ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-3"></div>
                                <div class="col-lg-6">

                                    <div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
                                        <div class="m-portlet__body">
                                            <div class="m-portlet__body form-float-input">

                                                <div class="form-group form-group--float form-group--icon <?= groupActiveState(input('CATEGORY_NAME')) ?>">
                                                    <input type="text" id="CATEGORY_NAME" name="CATEGORY_NAME" class="form-control" value="<?= input('CATEGORY_NAME') ?>">
                                                    <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                                                    <label for="name">عنوان دسته <i class="required">*</i></label>
                                                    <p class="help-block"></p>
                                                </div>

                                                <div class="form-group form-group--float form-group--icon <?= groupActiveState(input('CATEGORY_SLUG')) ?>">
                                                    <input type="text" id="CATEGORY_SLUG" name="CATEGORY_SLUG" class="form-control" value="<?= input('CATEGORY_SLUG') ?>">
                                                    <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                                                    <label for="name">نامک </label>
                                                    <p class="help-block"></p>
                                                </div>

                                                <div class="form-group form-group--float form-group--icon <?= groupActiveState(input('META_DESCRIPTION')) ?>">
                                                    <textarea name="META_DESCRIPTION" id="META_DESCRIPTION" class="form-control small"><?= input('META_DESCRIPTION') ?></textarea>
                                                    <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                                                    <label for="META_DESCRIPTION">متای description</label>
                                                </div>

                                                <div class="form-group form-group--float form-group--icon <?= groupActiveState(input('META_KEYWORDS')) ?>">
                                                    <textarea name="META_KEYWORDS" id="META_KEYWORDS" class="form-control small"><?= input('META_KEYWORDS') ?></textarea>
                                                    <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                                                    <label for="META_KEYWORDS">متای keywords</label>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </form>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
<?php include 'includes/_validate_js_variables.php' ?>

<!-- plugins -->
<script type="text/javascript" src="vendors/ckeditor/ckeditor.js"></script>
<script type="text/javascript" src="../public/lib/simple-ajax-uploader/SimpleAjaxUploader.min.js"></script>
<script src="vendors/bootstrap-colorpicker/dist/bootstrap-colorpicker.js"></script>

<script>
    var images_count = 1;
    var GLOBE__upload_url = 'process/pr_upload_category_image.php';
</script>

<!-- scripts -->
<script src="assets/app/js/custom/pages/upload.js"></script>
<script src="vendors/ckeditor/ckeditor.js"></script>

<script>
    startCKEditor('extra_description');
    initiateSelect2();
    startColorPicker('#colorpicker');
</script>
</body>
</html>

