<?php

use App\Category;
use App\Plan;

include 'init.php';

$page_slug = 'plans-list';
include 'check_auth.php';
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="<?= plansRoute('create') ?>" class="btn btn-info m-btn m-btn--custom m-btn--icon portlet-action-button">
                                <span><i class="la la-plus"></i><span>افزودن پلان جدید</span></span>
                            </a>

                            <?php include 'includes/help_button.php' ?>
                        </div>

                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">

                                <div class="table-responsive">
                                    <table class="table m-table table-bordered table-hover text-center big-header">
                                        <thead>
                                            <tr>
                                                <th>عنوان</th>
                                                <th>تعداد روزها</th>
                                                <th>قیمت (<?= setting('CURRENCY') ?>)</th>
                                                <th>نوع</th>
                                                <th>وضعیت</th>
                                                <th>عملیات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $Plan = new Plan();
                                            $plans = $Plan->all('ID DESC', true);

                                            if (! $plans) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($plans) :
                                                foreach ($plans as $plan) :
                                                /** @var Plan $plan */
                                            ?>
                                            <tr>
                                                <td><?= $plan->PLAN_TITLE ?></td>
                                                <td><?= $plan->PLAN_DAYS ?> روز</td>
                                                <td><?= not_empty($plan->PLAN_PRICE) ? number_format($plan->PLAN_PRICE) : "رایگان" ?></td>
                                                <td><?= $plan->type() ?></td>
                                                <td><?= $plan->status() ?></td>
                                                <td class="m-datatable__cell">
                                                    <a href="<?= $plan->editLink() ?>" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="ویرایش ">
                                                        <i class="la la-edit"></i>
                                                    </a>
                                                    <?php if ($plan->is_deletable()) : ?>
                                                    <form class="form-inline" method="POST" action="<?= $plan->deleteLink() ?>" data-confirm-delete>
                                                        <?= csrf_field() ?>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>
                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>

                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

</body>
</html>

