<?php

use App\Page;

include 'init.php';

$page_slug = 'pages-list';
include 'check_auth.php';
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="<?= pagesRoute('create') ?>" class="btn btn-info m-btn m-btn--custom m-btn--icon portlet-action-button">
                                <span><i class="la la-plus"></i><span>افزودن برگه جدید</span></span>
                            </a>

                            <?php include 'includes/help_button.php' ?>
                        </div>

                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">

                                <div class="table-responsive">
                                    <table class="table m-table table-bordered table-hover text-center big-header">
                                        <thead>
                                            <tr>
                                                <th>عنوان </th>
                                                <th>تاریخ ایجاد</th>
                                                <th>عملیات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $Page  = new Page();
                                            $pages = $Page->all();

                                            if (! $pages) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($pages) :
                                                foreach ($pages as $page) :
                                                    /** @var Page $page */
                                            ?>
                                            <tr>
                                                <td>
                                                    <?php if ($page->link() !== '#') : ?>
                                                        <a href="<?= $page->link() ?>" target="_blank"><?= $page->TITLE ?></a>
                                                    <?php else : ?>
                                                        <span><?= $page->TITLE ?></a></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?= miladiToShamsiAdmin($page->DATE_CREATED, "Y/m/d") ?></td>
                                                <td class="m-datatable__cell">
                                                    <a href="<?= $page->editLink() ?>" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="ویرایش ">
                                                        <i class="la la-edit"></i>
                                                    </a>
                                                    <?php if ($page->isDeletable()) : ?>
                                                        <form class="form-inline" method="post" action="<?= $page->deleteLink() ?>" data-confirm-delete>
                                                            <?= csrf_field() ?>
                                                            <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف">
                                                                <i class="la la-trash"></i>
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>
                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>

                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

</body>
</html>

