<?php

use App\Page;

include 'init.php';
$page_slug = 'pages-edit';
include 'check_auth.php';

$Page = new Page();
$page = $Page->byId(input('id'));

if (! $page || ! $page->isEditable()) {
    redirect(404);
}

if (isPost() && token()->check()) {
    checkDemoMode();

    include 'process/pages/_update.php';
}

if ($page->link() !== '#') {
    $top_menus = [
        [
            'icon' => 'flaticon-eye',
            'title' => 'مشاهده برگه',
            'link' => $page->link(),
        ]
    ];
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/bootstrap-colorpicker/dist/bootstrap-colorpicker.css">
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="submit-item-form">

                            <?= csrf_field() ?>

                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile" >
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= pagesRoute() ?>" class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                انصراف
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" name="submit_item" id="submit_item" class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                        <i class="la la-check"></i>ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-8">
                                    <?php include('includes/pages/edit/_fields.php') ?>
                                </div>
                                <div class="col-sm-4">
                                    <div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
                                        <div class="m-portlet__body" style="padding: 15px;">
                                            <div class="m-portlet__body p-0" id="widget-builder">
                                                <?php
                                                if ($page->hasWidgetArea()) {
                                                    include('includes/components/_widget_builder.php');
                                                } else {
                                                    echo "<h6>ناحیه ابزارکی برای این صفحه تعریف نشده است</h6>";
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </form>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>


<?php include 'includes/scripts.php' ?>

<script>
    var Globe__page_id = "<?php echo $page->ID ?>";
</script>

<script src="vendors/ckeditor/ckeditor.js"></script>
<script src="vendors/bootstrap-colorpicker/dist/bootstrap-colorpicker.js"></script>

<?php if ($page->hasWidgetArea()) : ?>
<script src="assets/vendors/vue/vue.js"></script>
<script src="assets/vendors/vue/axios.js"></script>
<script src="../node_modules/sortablejs/Sortable.min.js"></script>
<script src="../node_modules/vuedraggable/dist/vuedraggable.umd.min.js"></script>
<script src="assets/app/js/vue/widget_builder.js" defer></script>
<?php endif; ?>

<script>
    initiateSelect2();
    startColorPicker('.colorpicker_field');
    <?php
    foreach ($page->settings() as $setting) :
        if ($setting->type === 'textarea') :
    ?>
            startCKEditor("<?php echo $setting->key ?>");
    <?php
        endif;
    endforeach;
    ?>

    <?php if ($page->canEditBody()) : ?>
        startCKEditor('frm_content')
    <?php endif; ?>
</script>

</body>
</html>

