<?php

include 'init.php';
$page_slug = 'pages-create';
include 'check_auth.php';

if (isPost() && token()->check()) {
    checkDemoMode();

    include 'process/pages/_create.php';
}
 ?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="submit-item-form">

                            <?= csrf_field() ?>

                            <!--begin::Portlet-->
                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile" >
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= pagesRoute() ?>" class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                انصراف
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" name="submit_item" id="submit_item" class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                    <i class="la la-check"></i>ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-2"></div>
                                <div class="col-lg-8">
                                    <?php include('includes/pages/create/_fields.php') ?>
                                </div>
                            </div>

                        </form>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
<script src="vendors/ckeditor/ckeditor.js"></script>

<script>
    startCKEditor('frm_content');
</script>

</body>
</html>

