<?php

use App\Bacs;
use App\Order;

include 'init.php';
$page_slug = 'orders-view';
include 'check_auth.php';

$action = input('action');
if (!in_array($action, ['view', 'delete', 'verify'])) {
    abort();
}

$Order = new Order();
$order = $Order->byId(input('id'));

if (!$order) {
    abort();
}

if ($order->completed()) {
    $order->makeSeen();
}

if (isPost() &&input('action') === 'delete') {
    checkDemoMode();
    checkAccess('PAYMENT_CHANGE');

    $order->delete();

    session()->alert('success', 'عملیات حذف با موفقیت انجام شد');
    redirect('refer');
}

if (isPost() && input('action') === 'verify' && $order->isBacsGateway()) {
    checkDemoMode();
    checkAccess('PAYMENT_CHANGE');

    $Bacs = new Bacs();
    $Bacs->setOrder($order)->makeVerified();

    session()->success();
    redirect('refer');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <!--begin::Portlet-->
                        <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">
                            <div class="m-portlet__head">
                                <div class="m-portlet__head-progress">
                                    <!-- here can place a progress bar-->
                                </div>
                                <div class="m-portlet__head-wrapper">

                                    <?php include 'includes/portlet_header.php' ?>

                                    <div class="m-portlet__head-tools">
                                        <a href="<?= $order->isBacsGateway() ? ordersRoute('bacs') : ordersRoute('online') ?>"
                                           class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                            <i class="la la-arrow-right"></i>
                                            بازگشت
                                        </a>

                                        <?php include 'includes/help_button.php' ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-12">

                                <div class="invoice-wrapper">
                                    <div class="invoice">
                                        <?php
                                            include('includes/orders/_invoice.php');
                                        ?>

                                        <table class="invoice-table table">
                                            <thead>
                                            <tr>
                                                <th>شناسه آگهی</th>
                                                <th>عنوان آگهی</th>
                                                <th>توضیح</th>
                                                <th>هزینه</th>
                                            </tr>
                                            </thead>

                                            <tbody>
                                            <?php
                                            /** @var App\OrderItem $item */
                                            foreach($order->products() as $item) :
                                                ?>
                                                <tr>
                                                    <td><?= $item->productId() ?></td>
                                                    <td><?= $item->name ?></td>
                                                    <td><?= $item->description() ?></td>
                                                    <td><?= price_format($item->subtotal()) ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                            </tbody>
                                        </table>

                                        <div class="invoice-summary clearfix">
                                            <dl class="dl-horizontal pull-right">
                                                <dt>جمع کل:</dt>
                                                <dd><?= price_format($order->subtotal()) ?></dd>
                                                <dt>تخفیف ها:</dt>
                                                <dd>
                                                    <?php
                                                    /** @var App\OrderItem $coupon */
                                                    foreach ($order->coupons() as $coupon) :
                                                        ?>
                                                        - <?= price_format($coupon->discount()) ?> بابت استفاده از کد تخفیف <?= $coupon->name ?> <br>
                                                    <?php endforeach; ?>
                                                </dd>
                                                <dt class="final-price">هزینه نهایی:</dt>
                                                <dd class="final-price"><?= price_format($order->price) ?></dd>
                                            </dl>
                                        </div><!-- /.invoice-summary -->
                                    </div>
                                </div>


                            </div>
                        </div>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>

    initiateSelect2();
    initiateSelect2Tags();
</script>
</body>
</html>

