<?php

use Admin\Pagination;
use App\Order;

include 'init.php';

$page_slug = 'orders-bacs';
include 'check_auth.php';

if (isPost() && token()->check()) {
    checkDemoMode();

    include ('process/orders/_bulk_actions.php');
}

?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="m-alert m-alert--icon m-alert--air m-alert--square alert alert-dismissible m--margin-bottom-30" role="alert">
                    <div class="m-alert__icon">
                        <i class="flaticon-exclamation m--font-primary"></i>
                    </div>
                    <div class="m-alert__text">
                        در صورتی که هیچ فیلتری اعمال نشده باشد صرفا <strong><?= setting('ADMIN_PANEL_NOT_FILTERED_ADS_COUNT') ?></strong> مورد آخر
                        <?php if (! isDemoMode()) : ?>
                            (که طی یک ماه اخیر ثبت شده باشند)
                        <?php endif; ?>
                        نمایش داده خواهد شد. برای مشاهده نتایج بیشتر از بخش فیلتر استفاده نمایید
                    </div>
                </div>

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">

                            <ul class="m-portlet__nav">
                                <li class="m-portlet__nav-item">
                                    <div class="m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                                        <a href="#" class="m-portlet__nav-link btn btn-lg btn-secondary  m-btn m-btn--icon m-btn--icon-only m-btn--pill  m-dropdown__toggle">
                                            <i class="la la-ellipsis-h m--font-brand"></i>
                                        </a>
                                        <div class="m-dropdown__wrapper">
                                            <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust"></span>
                                            <div class="m-dropdown__inner">
                                                <div class="m-dropdown__body">
                                                    <div class="m-dropdown__content">

                                                        <form action="" method="post" class="nav-menu-form">
                                                            <?= csrf_field() ?>

                                                            <input type="hidden" name="action">

                                                            <ul class="m-nav">
                                                                <li class="m-nav__section m-nav__section--first">
                                                                    <span class="m-nav__section-text">عملیات ها</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="delete" data-irreversible="true">
                                                                        <i class="m-nav__link-icon fa fa-times"></i>
                                                                        <span class="m-nav__link-text">حذف</span>
                                                                    </a>
                                                                </li>

                                                                <?php if ($current_page->hasHelp()) : ?>
                                                                <li class="m-nav__section">
                                                                    <span class="m-nav__section-text">لینک های مفید</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-toggle="modal" data-target="#helpModal">
                                                                        <i class="m-nav__link-icon fa fa-question-circle"></i>
                                                                        <span class="m-nav__link-text">راهنما</span>
                                                                    </a>
                                                                </li>
                                                                <?php endif; ?>

                                                                <li class="m-nav__separator m-nav__separator--fit m--hide"></li>

                                                                <li class="m-nav__item m--hide">
                                                                    <a href="#" class="btn btn-outline-danger m-btn m-btn--pill m-btn--wide btn-sm">Submit</a>
                                                                </li>
                                                            </ul>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">
                                <form class="m-form m-form--fit m--margin-bottom-20">
                                    <div class="row m--margin-bottom-20">
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="order_id">شماره سفارش: </label>
                                            <input type="text" name="order_id" id="order_id" class="form-control m-input" value="<?= input('order_id') ?>">
                                        </div>
                                        <div class="col-lg-1 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="ads_id">شناسه آگهی:</label>
                                            <input type="text" name="ads_id" id="ads_id" class="form-control m-input" value="<?= input('ads_id') ?>">
                                        </div>
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="price">قیمت نهایی (تومان):</label>
                                            <input type="text" name="price" id="price" class="form-control m-input" value="<?= input('price') ?>">
                                        </div>
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="time">فیلتر زمانی :</label>
                                            <select class="form-control m-bootstrap-select selectpicker" name="time" id="type" data-col-index="2">
                                                <option value="0" <?= inputs()->is_set('time') || input('time') == 0 ? "selected" : false ?> >پیش فرض</option>
                                                <option value="1" <?= activeState(input('time'), 1) ?> > از 1 ماه قبل</option>
                                                <option value="3" <?= activeState(input('time'), 3) ?> > از 3 ماه قبل</option>
                                                <option value="6" <?= activeState(input('time'), 6) ?> > از 6 ماه قبل</option>
                                                <option value="12" <?= activeState(input('time'), 12) ?> >از یک سال قبل</option>
                                                <option value="all" <?= activeState(input('time'), 'all') ?> >همه </option>
                                            </select>
                                        </div>
                                        <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="time">کاربر ثبت کننده</label>
                                            <select data-remote-load-data
                                                    data-remote-url="process/ajax_calls.php?action=remote-load-users&type=minimal"
                                                    name="user"  class="form-control m-input m-select2" dir="rtl">
                                                <?php
                                                $user = null;
                                                if (inputs()->not_empty('user')) {
                                                    $user = $User->findById(input('user'));
                                                }
                                                if ($user) {
                                                    echo "<option value='{$user->USER_ID}'>{$user->username()}</option>";
                                                }
                                                ?>
                                                <option value="0">همه کاربران</option>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="m-separator m-separator--dashed"></div>

                                    <div class="row text-right">
                                        <div class="col-lg-12">
                                            <a href="<?= ordersRoute('bacs') ?>" class="btn btn-secondary m-btn m-btn--icon">
												<span>
													<i class="la la-close"></i>
													<span>پاک سازی</span>
												</span>
                                            </a>
                                            <button type="submit" class="btn btn-brand m-btn m-btn--icon">
												<span>
													<i class="la la-search"></i>
													<span>فیلتر</span>
												</span>
                                            </button>
                                        </div>
                                    </div>

                                </form>

                                <div class="table-responsive" style="margin-top: 50px">
                                    <table class="table table-bordered m-table table-hover">
                                        <thead>
                                        <tr>
                                            <th>
                                                <label class="m-checkbox m-checkbox--air m-checkbox--solid">
                                                    <input type="checkbox" data-click-checks-all-rows>
                                                    <span></span>
                                                </label>
                                            </th>
                                            <th>شماره سفارش</th>
                                            <th>عنوان آگهی</th>
                                            <th>قیمت نهایی (<?= setting('CURRENCY') ?>)</th>
                                            <th>تاریخ صدور</th>
                                            <th>وضعیت</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            //$id     = $title = $category = $type = $status = $time = $user = null;
                                            $order_id = $sale_id = $ads_id = $price = $status = $time = $user = $gateway = null;
                                            extract($_GET);

                                            $limited_days_for_not_filtered = 30;
//                                            $limited_days_for_not_filtered = 0;
                                            if (isDemoMode()) {
                                                $limited_days_for_not_filtered = 0;
                                            }

                                            $is_filtered = Order::isFiltered($order_id, $sale_id, $ads_id, $price, $status, $time, $user, false);

                                            if ($is_filtered) {
                                                $count = Order::countFilteredItems($order_id, $sale_id, $ads_id, $price, $status, $time, $user, true, false);
                                                $sql = Order::filteredSQL(false, true, $order_id, $sale_id, $ads_id, $price, $status, $time, $user, true, false);
                                            } else {
                                                $count = 0;
                                                $sql = Order::filteredSQL(false, false, $order_id, $sale_id, $ads_id, $price, $status, $time, $user, true, false, $limited_days_for_not_filtered);
                                            }

                                            $page = inputs()->not_empty('page') ? (int) input('page') : 1;
                                            $per_page = 15;
                                            $total_count = $count;

                                            $pagination = new Pagination($page, $per_page, $total_count);
                                            $pageParameters = array('order_id' => $order_id, 'sale_id' => $sale_id, 'ads_id' => $ads_id, 'price' => $price, 'status' => $status, 'time' => $time, 'user' => $user);
                                            $pagination->main_page = $pagination->makePageUrl(ordersRoute('bacs'), $pageParameters);

                                            if ($is_filtered) {
                                                $pagination->sql = $sql;
                                                $sql = $pagination->correct_sql();
                                            }

                                            $orders = Order::find_by_sql($sql);

                                            if (! $orders) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($orders) :
                                                $Order = new Order;
                                                $orders = $Order->eagerLoad('ads', $orders, 'ads_id');

                                                foreach ($orders as $order) :
                                                    /** @var Order $order */
                                            ?>
                                            <tr class="<?= ($order->completed() && ! $order->seen()) ? 'not-visited' : false ?>">
                                                <th scope="row">
                                                    <label class="m-checkbox"><input type="checkbox" class="to-be-checked" value="<?= $order->id ?>"><span></span></label>
                                                </th>
                                                <td><?= $order->sale_order_id ?></td>
                                                <td><a href="<?= $order->ads()->shortLink() ?>" target="_blank"><?= $order->ads()->ADS_TITLE ?></a></td>
                                                <td><?= number_format($order->price) ?></td>
                                                <td><?= ($order->date_created > 0 && $order->date_created !== NULL) ?  miladiToShamsiAdmin($order->date_created, "Y/m/d ساعت H:i", false) : null ?></td>
                                                <td><?= $order->generalStatus() ?></td>
                                                <td class="m-datatable__cell">
                                                    <form class="form-inline" method="post" action="<?= ordersRoute('verify', $order->id) ?>" data-confirm-show data-title=" آیا هزینه این صورتحساب توسط کاربر واریز شده است؟" data-subtitle="با کلیک بر روی بلی، این صورتحساب تایید شده و به بخش پرداختی های آنلاین اضافه خواهد شد">
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-brand m-btn--icon m-btn--icon-only m-btn--pill" title="پرداخت شده">
                                                            <i class="la la-check"></i>
                                                        </button>
                                                        <input type="hidden" name="action" value="verify">
                                                    </form>
                                                    <a href="<?= $order->viewLink() ?>" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="مشاهده صورتحساب ">
                                                        <i class="la la-eye"></i>
                                                    </a>
                                                    <form class="form-inline" method="post" action="<?= $order->deleteLink() ?>" data-confirm-delete>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف ">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>


                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>

                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>
                                    <?php if ($is_filtered) : ?>
                                        <div class="dataTables_wrapper">
                                            <div class="dataTables_paginate paging_full_numbers">
                                                <ul class="pagination">
                                                    <?php $pagination->show_pagination() ?>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>
    $('.selectpicker').selectpicker();
</script>
</body>
</html>

