<?php

use App\Menu;

include 'init.php';

$page_slug = 'menus-sort';
include 'check_auth.php';

$Menu = new Menu('main');

if (isPost() && token()->check()) {
    checkDemoMode();

    $ordered_array = json_decode(input('data'), true, 64);
    $Menu->saveSort($ordered_array);

    session()->success();
    redirect('refer');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/jquery-nestable/jquery.nestable-rtl.css">
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="nestable-from">

                            <?= csrf_field() ?>

                            <!--begin::Portlet-->
                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= menusRoute() ?>"
                                               class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                بازگشت
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" id="submit_item"
                                                        class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                    <i class="la la-check"></i>
                                                    ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">

                                <div class="col-lg-3"></div>

                                <div class="col-lg-6">

                                    <div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile"
                                         id="main-fields-wrapper" style="margin-top: 30px">
                                        <div class="m-portlet__body">
                                            <div class="m-portlet__body form-float-input">

                                                <div class="dd" id="nestable">
                                                    <ol class="dd-list">
                                                        <?php
                                                        $menus = $Menu->all('rang ASC');

                                                        /** @var Menu $menu */
                                                        foreach ($menus as $menu) :
                                                        ?>
                                                            <li class='dd-item' data-id='<?= $menu->id ?>'>
                                                                <div class='dd-handle'><i class="fa fa-align-justify"></i> <?= $menu->name ?></div>
                                                            </li>
                                                        <?php endforeach; ?>
                                                    </ol>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <label for="output"></label>
                            <textarea name="data" id="output" class="hidden"></textarea>

                        </form>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="vendors/jquery-nestable/jquery.nestable-rtl.js"></script>
<script src="assets/app/js/custom/pages/ui-nestable.js"></script>

</body>
</html>

