<?php

use App\MessageBox;
use App\SMS;

include 'init.php';

$page_slug = 'mailbox-sms';
include 'check_auth.php';

$MessageBox = new MessageBox('sms');

/**
 * Compose a new Email
 */
if (input('hi_is_reply') == 1) {
    $_POST['to'] = implode(',',input('to'));

    include('process/mailbox/_compose_sms.php');
}

/**
 * Bulk actions
 */
if (isPost() && token()->check()) {
    include ('process/mailbox/_bulk_actions.php');
}


?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="assets/app/css/pages/inbox.css">
    <link href="vendors/summernote/dist/summernote.rtl.css" rel="stylesheet" type="text/css">
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">

                            <a href="javascript" class="btn btn-brand m-btn m-btn--custom m-btn--icon m-btn--air portlet-action-button">
                                <!-- <span><i class="fa fa-dove"></i><span> اعتبار پنل پیامکی شما : <?= SMS::init()->getCredit() ?> پیامک</span></span> -->
                                <span><i class="fa fa-dove"></i><span> اعتبار پنل پیامکی شما : غیرقابل دسترسی</span></span>
                            </a>

                            <ul class="m-portlet__nav">
                                <li class="m-portlet__nav-item">
                                    <div class="m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                                        <a href="#" class="m-portlet__nav-link btn btn-lg btn-secondary  m-btn m-btn--icon m-btn--icon-only m-btn--pill  m-dropdown__toggle">
                                            <i class="la la-ellipsis-h m--font-brand"></i>
                                        </a>
                                        <div class="m-dropdown__wrapper">
                                            <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust"></span>
                                            <div class="m-dropdown__inner">
                                                <div class="m-dropdown__body">
                                                    <div class="m-dropdown__content">

                                                        <form action="" method="post" class="nav-menu-form">
                                                            <?= csrf_field() ?>

                                                            <input type="hidden" name="action">

                                                            <ul class="m-nav">
                                                                <li class="m-nav__section m-nav__section--first">
                                                                    <span class="m-nav__section-text">عملیات ها</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="delete" data-irreversible="true">
                                                                        <i class="m-nav__link-icon fa fa-times"></i>
                                                                        <span class="m-nav__link-text">حذف</span>
                                                                    </a>
                                                                </li>

                                                                <?php if ($current_page->hasHelp()) : ?>
                                                                <li class="m-nav__section">
                                                                    <span class="m-nav__section-text">لینک های مفید</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-toggle="modal" data-target="#helpModal">
                                                                        <i class="m-nav__link-icon fa fa-question-circle"></i>
                                                                        <span class="m-nav__link-text">راهنما</span>
                                                                    </a>
                                                                </li>
                                                                <?php endif; ?>

                                                                <li class="m-nav__separator m-nav__separator--fit m--hide"></li>

                                                                <li class="m-nav__item m--hide">
                                                                    <a href="#" class="btn btn-outline-danger m-btn m-btn--pill m-btn--wide btn-sm">Submit</a>
                                                                </li>
                                                            </ul>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="m-portlet__body">
                        <div class="row inbox">
                            <div class="col-lg-2">
                                <ul class="inbox-nav margin-bottom-10">
                                    <li class="compose-btn">
                                        <a href="javascript:;" data-title="ارسال پیامک" class="btn green size-18">
                                            <i class="icon-edit"></i> ارسال پیامک
                                        </a>
                                    </li>
                                    <li class="inbox active">
                                        <a href="javascript:;" class="btn size-13" data-title="دریافتی">دریافتی
                                            <?php
                                            $unread_count = $MessageBox->unreadCountFor($loggedUser->USER_ID, 30);
                                            echo !empty($unread_count) ? "({$unread_count})" : false;
                                            ?>
                                        </a>
                                        <b></b>
                                    </li>
                                    <li class="sent"><a class="btn size-13" href="javascript:;" data-title="ارسالی">ارسالی</a><b></b></li>
                                </ul>
                            </div>

                            <div class="col-lg-10">
                                <div class="inbox-header">
                                    <h1 class="pull-right">دریافتی</h1>
                                </div>
                                <div class="inbox-loading">در حال فراخوانی ...</div>
                                <div class="inbox-content"></div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
<script src="vendors/summernote/dist/summernote.js" type="text/javascript"></script>


<script>
    Globe__mailbox_type = "sms";
    GLOBE__page_number = "<?php echo inputs()->not_empty('page') ? (int) input('page') : 1; ?>";
</script>
<script src="assets/app/js/custom/pages/mailbox.js"></script>
<script src="assets/demo/custom/remote-select.js"></script>
<script>
    Inbox.init();

</script>
</body>
</html>

