<?php

use Admin\Pagination;
use App\Location;

include 'init.php';

$page_slug = 'locations-state';
include 'check_auth.php';

$location_type = 'state';
$Location = new Location($location_type);

if (inputs()->is_set('selected_values')) {
    checkDemoMode();

    include 'process/locations/states/_bulk_actions.php';
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="<?= locationsRoute('create') ?>" class="btn btn-info m-btn m-btn--custom m-btn--icon portlet-action-button">
                                <span><i class="la la-plus"></i><span>افزودن منطقه</span></span>
                            </a>
                            <ul class="m-portlet__nav">
                                <li class="m-portlet__nav-item">
                                    <div class="m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                                        <a href="#" class="m-portlet__nav-link btn btn-lg btn-secondary  m-btn m-btn--icon m-btn--icon-only m-btn--pill  m-dropdown__toggle">
                                            <i class="la la-ellipsis-h m--font-brand"></i>
                                        </a>
                                        <div class="m-dropdown__wrapper">
                                            <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust"></span>
                                            <div class="m-dropdown__inner">
                                                <div class="m-dropdown__body">
                                                    <div class="m-dropdown__content">

                                                        <form action="" method="post" class="nav-menu-form">
                                                            <?= csrf_field() ?>

                                                            <input type="hidden" name="action">

                                                            <ul class="m-nav">
                                                                <li class="m-nav__section m-nav__section--first">
                                                                    <span class="m-nav__section-text">عملیات ها</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="delete" data-irreversible="true">
                                                                        <i class="m-nav__link-icon fa fa-times"></i>
                                                                        <span class="m-nav__link-text">حذف</span>
                                                                    </a>
                                                                </li>

                                                                <?php if ($current_page->hasHelp()) : ?>
                                                                    <li class="m-nav__section">
                                                                        <span class="m-nav__section-text">لینک های مفید</span>
                                                                    </li>
                                                                    <li class="m-nav__item">
                                                                        <a href="javascript:" class="m-nav__link" data-toggle="modal" data-target="#helpModal">
                                                                            <i class="m-nav__link-icon fa fa-question-circle"></i>
                                                                            <span class="m-nav__link-text">راهنما</span>
                                                                        </a>
                                                                    </li>
                                                                <?php endif; ?>

                                                                <li class="m-nav__separator m-nav__separator--fit m--hide"></li>

                                                                <li class="m-nav__item m--hide">
                                                                    <a href="#" class="btn btn-outline-danger m-btn m-btn--pill m-btn--wide btn-sm">Submit</a>
                                                                </li>
                                                            </ul>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">
                                <form class="m-form m-form--fit m--margin-bottom-20">
                                    <div class="row m--margin-bottom-20">
                                        <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="state">نام استان:</label>
                                            <input type="text" name="state" id="state" class="form-control m-input" value="<?= input('state') ?>">
                                        </div>
                                    </div>

                                    <div class="m-separator m-separator--dashed"></div>

                                    <div class="row text-right">
                                        <div class="col-lg-12">
                                            <a href="<?= locationsRoute('states') ?>" class="btn btn-secondary m-btn m-btn--icon">
												<span>
													<i class="la la-close"></i>
													<span>پاک سازی</span>
												</span>
                                            </a>
                                            <button type="submit" class="btn btn-brand m-btn m-btn--icon">
												<span>
													<i class="la la-search"></i>
													<span>فیلتر</span>
												</span>
                                            </button>
                                        </div>
                                    </div>

                                </form>

                                <div class="table-responsive"  style="margin-top: 50px">
                                    <table class="table table-bordered m-table table-hover">
                                        <thead>
                                        <tr>
                                            <th>
                                                <label class="m-checkbox m-checkbox--air m-checkbox--solid">
                                                    <input type="checkbox" data-click-checks-all-rows>
                                                    <span></span>
                                                </label>
                                            </th>
                                            <th>شناسه</th>
                                            <th>نام استان</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $zone = $city = $state = null;
                                            extract($_GET);

                                            $stmt = $Location->filter($state, $city, $zone);
                                            $sql  = data_get($stmt,'sql');
                                            $locations = data_get($stmt,'result');
                                            $is_filtered = data_get($stmt,'is_filtered');

                                            $page = inputs()->not_empty('page') ? (int) input('page') : 1 ;
                                            $per_page = 15;
                                            $total_count = count($locations);

                                            $pagination = new Pagination($page, $per_page, $total_count);
                                            $pageParameters = array('city' => $city, 'state' => $state);
                                            $pagination->main_page = $pagination->makePageUrl(locationsRoute('states'), $pageParameters);
                                            $pagination->sql = $sql;

                                            if ($is_filtered) {
                                                $query = $pagination->correct_sql();
                                                $locations = $Location->find_by_sql($query, ['type' => $location_type]);
                                            }

                                            if (! $locations) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($locations) :
                                                foreach ($locations as $location) :
                                                    /** @var Location $location */
                                            ?>
                                            <tr>
                                                <th scope="row">
                                                    <label class="m-checkbox"><input type="checkbox" class="to-be-checked" value="<?= $location->id() ?>"><span></span></label>
                                                </th>
                                                <td><?=  $location->id() ?></td>
                                                <td><?= $location->STATE_NAME ?></td>
                                                <td class="m-datatable__cell">
                                                    <a href="<?= $location->editLink() ?>" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="ویرایش ">
                                                        <i class="la la-edit"></i>
                                                    </a>
                                                    <form class="form-inline" action="<?= $location->deleteLink() ?>" data-confirm-delete>
                                                        <input type="hidden" name="type" value="state">
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف ">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>

                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>
                                    <?php if ($is_filtered) : ?>
                                        <div class="dataTables_wrapper">
                                            <div class="dataTables_paginate paging_full_numbers">
                                                <ul class="pagination">
                                                    <?php $pagination->show_pagination() ?>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>
    $('.selectpicker').selectpicker();
</script>
</body>
</html>

