<?php

use App\Link;

include 'init.php';

$page_slug = 'links-list';
include 'check_auth.php';


if (isPost() && token()->check() && input('action') === 'update') {
    checkDemoMode();

    $Link = new Link();
    $link = $Link->byId(input('id'));
    if ($link) {
        $link->update(inputs()->all());
    }

    session()->success();
    redirect('refer');
}

if (input('action') === 'create') {
    checkDemoMode();

    $Link = new Link();
    $Link->createNew(inputs()->all());

    session()->success();
    redirect('refer');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="#create-modal" role="button" data-toggle="modal" class="btn btn-info m-btn m-btn--custom m-btn--icon portlet-action-button">
                                <span><i class="la la-plus"></i><span>افزودن لینک </span></span>
                            </a>

                            <?php include 'includes/help_button.php' ?>
                        </div>

                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">

                                <div class="table-responsive">
                                    <table class="table m-table table-bordered table-hover text-center big-header">
                                        <thead>
                                            <tr>
                                                <th>شناسه</th>
                                                <th> عنوان لینک </th>
                                                <th> آدرس لینک </th>
                                                <th>عملیات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $Link = new Link();
                                            $links = $Link->all(0, "ID DESC");

                                            if (! $links) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($links) :
                                                foreach ($links as $link) :
                                                    /** @var Link $link */
                                                ?>
                                            <tr>
                                                <td><?= $link->ID ?></td>
                                                <td><?= $link->LINK_TITLE ?></td>
                                                <td class="ltr foreign text-center"><a href="<?= addHttp($link->LINK_ADDRESS) ?>" target="_blank"><?= $link->LINK_ADDRESS ?></a></td>
                                                <td class="m-datatable__cell">
                                                    <a href="#edit-modal-<?= $link->ID ?>" role="button" data-toggle="modal" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="ویرایش ">
                                                        <i class="la la-edit"></i>
                                                    </a>

                                                    <form class="form-inline" method="POST" action="<?= $link->deleteLink() ?>" data-confirm-delete>
                                                        <?= csrf_field() ?>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>

                                            <div class="modal fade" id="edit-modal-<?= $link->ID ?>" tabindex="-1" role="dialog" aria-labelledby="edit-modal" aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                    <div class="modal-content">

                                                        <form action="<?=  $link->updateLink() ?>" method="post" class="form-float-input">

                                                            <?= csrf_field() ?>

                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="addModalLongTitle">ویرایش لینک</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>

                                                            <div class="modal-body">
                                                                <div class="col-lg-12">

                                                                    <div class="form-group form-group--float form-group--icon form-group--active">
                                                                        <input type="text" id="LINK_TITLE" name="LINK_TITLE" class="form-control" value="<?= $link->LINK_TITLE ?>">
                                                                        <span class="input-icon-addon top-3"> <i class="fa fa-share-alt"></i> </span>
                                                                        <label for="LINK_TITLE">عنوان لینک</label>
                                                                    </div>

                                                                    <div class="form-group form-group--float form-group--icon form-group--active m-t-40">
                                                                        <input type="text" id="LINK_ADDRESS" name="LINK_ADDRESS" class="form-control ltr foreign" value="<?= $link->LINK_ADDRESS ?>">
                                                                        <span class="input-icon-addon top-3"> <i class="fa fa-link"></i> </span>
                                                                        <label for="LINK_ADDRESS">آدرس لینک</label>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary m-btn m-btn--icon" data-dismiss="modal">
                                                                    <span><i class="la la-remove"></i><span>انصراف</span></span>
                                                                </button>
                                                                <button type="submit" class="btn btn-success m-btn m-btn--icon">
                                                                    <span><i class="la la-check"></i><span>ویرایش</span></span>
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>

                                            <?php
                                                endforeach;
                                            endif;
                                            ?>
                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>

                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="create-modal" tabindex="-1" role="dialog" aria-labelledby="create-modal" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">

                <form action="<?= linksRoute('create') ?>" method="post" class="form-float-input">

                    <?= csrf_field() ?>

                    <div class="modal-header">
                        <h5 class="modal-title" id="addModalLongTitle">افزودن لینک</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <div class="modal-body">
                        <div class="col-lg-12">

                            <div class="form-group form-group--float form-group--icon form-group--active">
                                <input type="text" id="LINK_TITLE" name="LINK_TITLE" class="form-control">
                                <span class="input-icon-addon top-3"> <i class="fa fa-share-alt"></i> </span>
                                <label for="LINK_TITLE">عنوان لینک</label>
                            </div>

                            <div class="form-group form-group--float form-group--icon form-group--active m-t-40">
                                <input type="text" id="LINK_ADDRESS" name="LINK_ADDRESS" class="form-control ltr foreign">
                                <span class="input-icon-addon top-3"> <i class="fa fa-link"></i> </span>
                                <label for="LINK_ADDRESS">آدرس لینک</label>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary m-btn m-btn--icon" data-dismiss="modal">
                            <span><i class="la la-remove"></i><span>انصراف</span></span>
                        </button>
                        <button type="submit" class="btn btn-success m-btn m-btn--icon">
                            <span><i class="la la-check"></i><span>ثبت</span></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

</body>
</html>

