<?php
use App\Cache;
use App\Cookie;
use App\Input;
use App\Session;
use App\Support;
use App\Token;
use Illuminate\Container\Container;

session_start();
ob_start();

require_once(__DIR__ . '/../vendor/autoload.php');
date_default_timezone_set("Asia/Tehran");

defined('DS')               ? null : define('DS',               DIRECTORY_SEPARATOR);
defined('SITE_ROOT')        ? null : define('SITE_ROOT',        str_replace(DS."adm-kodes", "", dirname(__FILE__)).DS);
defined('LIB_PATH')         ? null : define('LIB_PATH',         SITE_ROOT.'funcs'.DS);
defined('ADMIN_PATH')       ? null : define('ADMIN_PATH',       dirname(__FILE__).DS);
defined('LANG_PATH')        ? null : define('LANG_PATH',        SITE_ROOT.'languages'.DS);
defined('TEMPLATES_PATH')   ? null : define('TEMPLATES_PATH',   SITE_ROOT.'templates'.DS);
defined('IMAGES_PATH')      ? null : define('IMAGES_PATH',      SITE_ROOT.'images'.DS);
defined('VENDOR_PATH')      ? null : define('VENDOR_PATH',      SITE_ROOT.'vendor'.DS);
defined('BACKUP_PATH')      ? null : define('BACKUP_PATH',      SITE_ROOT.'backups'.DS);
defined('CACHE_PATH')       ? null : define('CACHE_PATH',       SITE_ROOT.'cache');

if (is_dir(SITE_ROOT."setup"))
    : die("<div style='text-align:center'>"
    . "<span style='padding: 5px; border: 1px solid #999; background-color:#EFEFEF;"
    . "font-family: Verdana; font-size: 11px; margin-left:auto; margin-right:auto'>"
    . "<b>Warning:</b> Please delete setup directory!</span></div>");
endif;

include(LIB_PATH.'config.ini.php');
include(SITE_ROOT.'bootstrap/database.php');
include(SITE_ROOT.'bootstrap/config.php');

/*---------------------------
| Instantiate the Container
----------------------------*/
$app = new Container();


/*-------------------------
| Instantiate Input Class
---------------------------*/
$app->singleton('input', function(){
    return new Input();
});

/*----------------------------------------
| Instantiate the cache manager
------------------------------------------*/
$app->singleton('cache', function(){
    return new Cache();
});

/*----------------------------------------
| Instantiate the Session
------------------------------------------*/
$app->singleton('session', function(){
    return new Session();
});

/*----------------------------------------
| Instantiate the Cookie Class
------------------------------------------*/
$app->singleton('cookie', function(){
    return new Cookie();
});

/*-------------------------
| Instantiate Token Class
---------------------------*/
$app->singleton('token', function(){
    return new Token();
});

/*-------------------------
| Instantiate Support Class
---------------------------*/
$app->singleton('support', function(){
    return new Support();
});


/*----------------------------------------
| Fetch Site Settings
------------------------------------------*/
$Setting = new App\Setting();
$options = $Setting->all();

include(LANG_PATH . lang() . '.php');
include(SITE_ROOT .'shared/data.php');
include(ADMIN_PATH.'routes.php');

// error_reporting(E_ALL);
// ini_set('display_errors', '1');
ini_set("display_errors", 0);