<?php

use App\Affiliate;

?>
<div class="m-portlet__body">

    <div class="m-section">
        <div class="m-section__content">
            <div class="table-responsive">
                <table class="table table-bordered m-table table-hover  big-header">
                    <thead>
                    <tr>
                        <th><i class="fa fa-bullhorn"></i>  آگهی ها/پلان ها</th>
                        <th><i class="fa fa-dollar-sign"></i>  مبلغ (<?= setting('CURRENCY') ?>)</th>
                        <th><i class="fa fa-money-bill-wave"></i> کمیسیون (<?= setting('CURRENCY') ?>)</th>
                        <th><i class="fa fa-calendar"></i> تاریخ ثبت </th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php
                        $affiliates = $Affiliate->userAffiliates($user->USER_ID,0,5);

                        if (! $affiliates) {
                            echo "<tr> <td colspan='4' class='table-no-record-found'>هیچ رکوردی یافت نشد</td> </tr>";
                        }

                        if ($affiliates) :
                            foreach ($affiliates as $affiliate) :
                                /* @var Affiliate $affiliate */
                        ?>
                        <tr>
                            <td><?= $affiliate->comment  ?></td>
                            <td><?= number_format($affiliate->price) ?></td>
                            <td><?= number_format($affiliate->commision) ?></td>
                            <td><?= miladiToShamsiAdmin($affiliate->date_created, "Y/m/d") ?></td>
                            <td><?= $affiliate->showStatus() ?></td>
                        </tr>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>