<?php

use App\Order;

?>
<div class="m-portlet__body">

    <div class="m-section">
        <div class="m-section__content">
            <div class="table-responsive">
                <table class="table table-bordered m-table table-hover  big-header">
                    <thead>
                    <tr>
                        <th>شماره سفارش</th>
                        <th>قیمت (<?= setting('CURRENCY') ?>)</th>
                        <th>نحوه پرداخت</th>
                        <th>تاریخ</th>
                        <th> وضعیت </th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php
                        $orders = $Order->userPayments($user->USER_ID);

                        if (! $orders) {
                            echo "<tr> <td colspan='4' class='table-no-record-found'>هیچ رکوردی یافت نشد</td> </tr>";
                        }

                        if ($orders) :
                            foreach ($orders as $order) :
                                /* @var Order $order */
                        ?>
                        <tr>
                            <td><?php echo $order->sale_order_id ?></td>
                            <td><?php echo number_format($order->price) ?></td>
                            <td><?php echo $order->paymentKind() ?></td>
                            <td><?php echo miladiToShamsiAdmin($order->date_created, "Y/m/d ساعت H:i", false) ?>  </td>
                            <td><?php echo $order->generalStatus() ?></td>
                        </tr>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>