<div class="activities">

    <div v-if="isLoading" class="text-center">
        <i class="fa fa-spinner fa-spin big-loading"></i>
    </div>

    <div class="m-list-timeline" v-if="! isLoading && activities.length">
        <div class="m-list-timeline__items">
            <div class="m-list-timeline__item" v-for="activity in activities" :key="activity.id">
                <span class="m-list-timeline__badge m-list-timeline__badge--success"></span>
                <span class="m-list-timeline__icon" :class="activityIcon(activity.type)"></span>
                <span class="m-list-timeline__text" v-html="activity.html"></span>
                <span class="m-list-timeline__time">{{ activity.date }}</span>
            </div>
        </div>
    </div>

    <div v-if="! isLoading && error" class="text-center error">
        <div class="m-alert m-alert--icon alert alert-danger m-alert--outline" role="alert">
            <div class="m-alert__icon">
                <i class="la la-warning"></i>
            </div>
            <div class="m-alert__text">
                {{ error }}
            </div>
            <div class="m-alert__actions" style="width: 160px;">
                <a href="<?= support()->supportLink() ?>" type="button" class="btn btn-danger btn-sm m-btn m-btn--pill m-btn--wide">ارتباط با پشتیبانی</a>
            </div>
        </div>
    </div>
</div>