<div class="activities">

    <div v-if="isLoading" class="text-center">
        <i class="fa fa-spinner fa-spin big-loading"></i>
    </div>

    <div class="m-list-timeline" v-if="! isLoading && callouts.length">
        <div class="m-list-timeline__items">
            <div class="m-list-timeline__item" v-for="callout in callouts" :key="callout.id">
                <span class="m-list-timeline__badge m-list-timeline__badge--success"></span>
                <span class="m-list-timeline__icon fa fa-bell"></span>
                <span class="m-list-timeline__text">{{ callout.title }} <small><a href="#" @click.prevent="openCallout(callout)">جزئیات بیشتر</a></small></span>
                <span class="m-list-timeline__time">{{ callout.formatted_date }}</span>
            </div>
        </div>
    </div>

    <div class="vue-modalDialog" v-if="showModal">
        <section>
            <a title="Close" class="close" @click.prevent="showModal = false">X</a>

            <div class="vue-modalDialog__body" :class="{ withImage: currentCallout.image_url, withLink: currentCallout.link }" :style="{ 'background-image': 'url(' + currentCallout.image_url + ')' }" @click="bannerClicked">

                <h2 class="vue-modalDialog__title">{{ currentCallout.title }}</h2>

                <div v-html="currentCallout.body"></div>

                <div class="text-center vue-modalDialog__link">
                    <a class="btn btn-xs btn-info" :href="currentCallout.link" v-if="currentCallout.link" target="_blank">کلیک کنید</a>
                </div>
            </div>
        </section>
    </div>

    <div v-if="! isLoading && error" class="text-center error">
        <div class="m-alert m-alert--icon alert alert-danger m-alert--outline" role="alert">
            <div class="m-alert__icon">
                <i class="la la-warning"></i>
            </div>
            <div class="m-alert__text">
                {{ error }}
            </div>
            <div class="m-alert__actions" style="width: 160px;">
                <a href="<?= support()->supportLink() ?>" type="button" class="btn btn-danger btn-sm m-btn m-btn--pill m-btn--wide">ارتباط با پشتیبانی</a>
            </div>
        </div>
    </div>


</div>