<?php
use App\PostCategory;
/* @var App\Post $post */
?>
<div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
    <div class="m-portlet__body">
        <div class="m-portlet__body form-float-input">

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($post->TITLE) ?>">
                <input type="text" id="frm_title" name="frm_title" class="form-control" value="<?= $post->TITLE ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="frm_title">عنوان پست:</label>
                <p class="help-block"></p>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($post->SLUG) ?>">
                <input type="text" id="slug" name="slug" class="form-control" value="<?= $post->SLUG ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="slug">نامک:</label>
                <p class="help-block"></p>
            </div>

            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="category">دسته بندی: </label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                        <select name="category" id="category" class="form-control advanced-select">
                            <option value="0" disabled selected style="display: none;"><?php _e('CHOOSE') ?></option>
                            <?php
                            $PostCategory = new PostCategory();
                            foreach($PostCategory->lists() AS $category){
                                echo "<option value='{$category->ID}' " . activeState($category->ID, $post->CATEGORY_ID) . ">{$category->CATEGORY_NAME}</option>";
                            }
                            ?>
                        </select>
                        <p class="help-block"></p>
                    </div>
                </div>

            </div>


            <div class="form-group">
                <label for="frm_text"><h5> متن کامل پست :</h5> </label>
                <textarea type="text" name="frm_text" id="frm_text"><?= $post->POST_TEXT ?></textarea>
            </div>

            <div class="form-group select-group--float form-group--float form-group--icon">
                <label for="frm_keywords"><?php _e('TAGS') ?></label>
                <select class="form-control advanced-select-tags" name="frm_keywords[]" id="frm_keywords" multiple="multiple">
                    <?php
                    $tags = $post->tags();
                    foreach ($tags as $tag) {
                        echo "<option selected>{$tag->TAG_NAME}</option>";
                    }
                    ?>
                </select>
                <div id="tags-input-help" class="input-sticky-help tags-help"><i class='fa fa-question-circle'></i></div>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($post->POST_META_DESCRIPTION) ?>">
                <textarea name="meta_description" id="meta_description" class="form-control small"><?= $post->POST_META_DESCRIPTION ?></textarea>
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="meta_description"> متای description : </label>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($post->POST_META_KEYWORDS) ?>">
                <textarea name="meta_keywords" id="meta_keywords" class="form-control small"><?= $post->POST_META_KEYWORDS ?></textarea>
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="meta_keywords"> متای keywords : </label>
            </div>

        </div>
    </div>
</div>