<?php
/* @var App\Plan $plan */
?>
<div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
    <div class="m-portlet__body">
        <div class="m-portlet__body form-float-input">

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($plan->PLAN_TITLE) ?>">
                <input type="text" id="PLAN_TITLE" name="PLAN_TITLE" class="form-control" value="<?= $plan->PLAN_TITLE ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="name">عنوان پلان  </label>
                <p class="help-block"></p>
            </div>

            <div class="m-form__group row">
                <?php if ($plan->hasStars()) : ?>
                    <div class="col-lg-6">
                        <div class="form-group select-group--float form-group--float form-group--icon">
                            <label for="PLAN_STARS"> تعداد ستاره ها </label>
                            <span class="input-icon-addon top-3"> <i class="fa fa-star"></i> </span>
                            <select name="PLAN_STARS" id="PLAN_STARS" class="form-control advanced-select">
                                <?php
                                for ($i = 1; $i <= setting('TOTAL_STARS'); $i++) {
                                    echo "<option value='{$i}' " . activeState($plan->PLAN_STARS, $i) . ">{$i}</option>";
                                }
                                ?>
                            </select>
                            <p class="help-block"></p>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (! $plan->is_text()) : ?>
                    <div class="col-lg-6">
                        <div class="form-group select-group--float form-group--float form-group--icon">
                            <label for="PLAN_PRIORITY"> اولویت در موتور جستجو </label>
                            <span class="input-icon-addon top-3"> <i class="la la-sort"></i> </span>
                            <select name="PLAN_PRIORITY" id="PLAN_PRIORITY" class="form-control advanced-select">
                                <?php
                                for ($i = 1; $i <= (setting('TOTAL_STARS') + 1); $i++) {
                                    echo "<option value='{$i}' " . activeState($plan->PLAN_PRIORITY, $i) . ">{$i}</option>";
                                }
                                ?>
                            </select>
                            <p class="help-block"></p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="m-form__group row">
                <?php if (! $plan->isFree()) : ?>
                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon form-group--active <?= groupActiveState($plan->PLAN_PRICE) ?>">
                        <input type="text" id="PRICE" name="PRICE" class="form-control digits-field" value="<?= $plan->PLAN_PRICE ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                        <label for="PRICE">قیمت پلان (<?= setting('CURRENCY') ?>)</label>
                        <div class="help-block"></div>
                        <div class="digits-divider"></div>
                    </div>
                </div>
                <?php endif; ?>

                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon form-group--active <?= groupActiveState($plan->PLAN_DAYS) ?>">
                        <input type="text" id="PLAN_DAYS" name="PLAN_DAYS" class="form-control digits-field" value="<?= $plan->PLAN_DAYS ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                        <label for="PLAN_DAYS">تعداد روزها</label>
                        <div class="help-block"></div>
                    </div>
                </div>
            </div>

            <?php if (! $plan->is_text()) : ?>
            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon form-group--active <?= groupActiveState($plan->MAX_IMG_COUNT) ?>">
                        <input type="text" id="MAX_IMG_COUNT" name="MAX_IMG_COUNT" class="form-control digits-field" value="<?= $plan->MAX_IMG_COUNT ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                        <label for="MAX_IMG_COUNT">حداکثر تعداد تصاویر</label>
                        <div class="help-block"></div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon form-group--active <?= groupActiveState($plan->PLAN_UPDATE_TIMES) ?>">
                        <input type="text" id="PLAN_UPDATE_TIMES" name="PLAN_UPDATE_TIMES" class="form-control digits-field" value="<?= $plan->PLAN_UPDATE_TIMES ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                        <label for="PLAN_UPDATE_TIMES">حداکثر تعداد جهش</label>
                        <div class="help-block"></div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon form-group--active <?= groupActiveState($plan->MAX_KEYWORD_COUNT) ?>">
                        <input type="text" id="MAX_KEYWORD_COUNT" name="MAX_KEYWORD_COUNT" class="form-control digits-field" value="<?= $plan->MAX_KEYWORD_COUNT ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                        <label for="MAX_KEYWORD_COUNT">حداکثر تعداد کلمات کلیدی</label>
                        <div class="help-block"></div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon form-group--active <?= groupActiveState($plan->RIBBON_TEXT) ?>">
                        <input type="text" id="RIBBON_TEXT" name="RIBBON_TEXT" class="form-control" value="<?= $plan->RIBBON_TEXT ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-flag"></i> </span>
                        <label for="RIBBON_TEXT">متن روبان</label>
                        <div class="help-block">در صورت خالی گذاشتن، روبان نمایش داده نخواهد شد</div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>