<div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
    <div class="m-portlet__body">
        <div class="m-portlet__body form-float-input">

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($page->TITLE) ?>">
                <input type="text" id="frm_title" name="frm_title" class="form-control" value="<?= $page->TITLE ?>" <?= (! $page->canEditTitle()) ? 'disabled' : false ?>>
                <span class="input-icon-addon top-3"> <i class="fa fa-clone"></i> </span>
                <label for="frm_title">عنوان برگه</label>
                <?php if ($page->canEditTitle()) : ?>
                <div class="help-block">عنوان برگه می تواند فارسی و یا لاتین باشد </div>
                <?php endif; ?>
            </div>

            <?php foreach ($page->settings() as $setting) : ?>

                <?php if ($setting->type === 'textarea') : ?>
                    <div class="form-group">
                        <label for="meta_<?= $setting->key ?>"><?= $setting->name ?></label>
                        <textarea name="meta_<?= $setting->key ?>" id="<?= $setting->key ?>" class="form-control medium"><?= $setting->value ?></textarea>
                        <p class="help-block"><?= $setting->description ?></p>
                    </div>
                <?php endif; ?>

                <?php if ($setting->type === 'text' || $setting->type === 'number') : ?>
                    <div class="form-group form-group--float form-group--icon form-group--active">
                        <input type="text" id="meta_<?= $setting->key ?>" name="meta_<?= $setting->key ?>" class="form-control" value="<?= $setting->value ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                        <label for="meta_<?= $setting->key ?>"><?= $setting->name ?></label>
                        <p class="help-block"><?= $setting->description ?></p>
                    </div>
                <?php endif; ?>

                <?php if ($setting->type === 'boolean') : ?>
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="meta_<?= $setting->key ?>"><?= $setting->name ?></label>
                        <select name="meta_<?= $setting->key ?>" id="<?= $setting->key ?>" class="form-control advanced-select">
                            <option value="YES" <?= activeState($setting->value, 'YES') ?>><?php _e('YES') ?></option>
                            <option value="NO" <?= activeState($setting->value, 'NO') ?>><?php _e('NO') ?></option>
                        </select>
                        <p class="help-block"><?= $setting->description ?></p>
                    </div>
                <?php endif; ?>

                <?php if ($setting->type === 'select') : ?>
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="meta_<?= $setting->key ?>"><?= $setting->name ?></label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                        <select name="meta_<?= $setting->key ?>" id="meta_<?= $setting->key ?>" class="form-control advanced-select">
                            <?php foreach ($setting->options as $key => $value): ?>
                                <option value="<?= $key ?>" <?= activeState($key, $setting->value) ?>><?= $value ?></option>
                            <?php endforeach; ?>
                        </select>
                        <p class="help-block"><?= $setting->description ?></p>
                    </div>
                <?php endif; ?>

                <?php if ($setting->type === 'colorpicker') : ?>
                    <div class="form-group m-form__group colorpicker_field">
                        <label for="meta_<?= $setting->key ?>"><?= $setting->name ?></label>
                        <div class="input-group">
                            <input type="text" name="meta_<?= $setting->key ?>" id="meta_<?= $setting->key ?>" class="form-control input-lg bold-border" value="<?= $setting->value ?>">
                            <div class="input-group-append">
                                <span class="input-group-text colorpicker-input-addon"><i></i></span>
                            </div>
                        </div>
                        <p class="help-block"><?= $setting->description ?></p>
                    </div>
                <?php endif; ?>

            <?php endforeach; ?>


            <?php if ($page->canEditSlug()) : ?>
            <div class="form-group form-group--float form-group--icon <?= groupActiveState($page->SLUG) ?>">
                <input type="text" id="frm_slug" name="frm_slug" class="form-control" value="<?= $page->SLUG ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-clone"></i> </span>
                <label for="frm_slug">نامک</label>
                <p class="help-block"> باید یک نام لاتین به عنوان شناسه برگه وارد نمایید.این نام باید بدون فاصله وارد شود. در صورت نیاز به جای فاصله از علامت <span class='foreign'> - </span> استفاده کنید. مثال : <span class='foreign'>a-new-page</span> </p>
            </div>
            <?php endif; ?>

            <?php if ($page->canEditBody()) : ?>
            <div class="m-form__group">
                <label for="frm_content"><h5> محتوای برگه :</h5> </label>
                <textarea type="text" name="frm_content" id="frm_content"><?= $page->BODY ?></textarea>
            </div>
            <?php endif; ?>

            <?php if ($page->canEditSeoFields()) : ?>
                <div class="divided-title" style="margin-right: -40px; margin-left: -40px;">
                    <span class="title"> سئو </span>
                    <span class="divider"></span>
                </div>

                <div class="form-group form-group--float form-group--icon form-group--active m-t-40">
                    <input type="text" id="META_TITLE" name="META_TITLE" class="form-control"  value="<?= $page->META_TITLE ?>">
                    <span class="input-icon-addon top-3"> <i class="fa fa-clone"></i> </span>
                    <label for="META_TITLE"> عنوان برای موتورهای جستجو (سئو :: تگ title) </label>
                </div>

                <div class="form-group form-group--float form-group--icon form-group--active">
                    <input type="text" id="META_KEYWORDS" name="META_KEYWORDS" class="form-control"  value="<?= $page->META_KEYWORDS ?>">
                    <span class="input-icon-addon top-3"> <i class="fa fa-clone"></i> </span>
                    <label for="META_KEYWORDS">توضیحات (سئو :: تگ keywords)</label>
                    <div class="help-block"></div>
                </div>

                <div class="form-group form-group--float form-group--icon form-group--active">
                    <textarea name="META_DESCRIPTION" id="META_DESCRIPTION" class="form-control medium"><?= $page->META_DESCRIPTION ?></textarea>
                    <span class="input-icon-addon top-3"> <i class="fa fa-clone"></i> </span>
                    <label for="META_DESCRIPTION">کلمات کلیدی (سئو :: تگ description)</label>
                    <div class="help-block m-t-5"> کلمات کلیدی را با کاما , از هم جدا کنید</div>
                </div>
            <?php endif; ?>

        </div>
    </div>
</div>
