<?php

use App\Order;
use App\Shamsi;

$Shamsi = new Shamsi();
$Order = new Order();

$current_year = $Shamsi->currentYear();
$year = input('year') ?: $current_year;
$month = input('month') ?: $Shamsi->currentMonth();

$month_days = $Shamsi->forge("{$year}-{$month}-01 00:00:00", ['format' => 'Y-m-d H:i:s'])->getMonthDays();

$data_array = "";
for ($i = 1; $i <= $month_days; $i++) {
    $j = ($i < 10) ? "0".$i : $i;

    $start_date = $Shamsi->parse("{$year}-{$month}-{$j} 00:00:00", true, ['format' => 'Y-m-d H:i:s']);
    $end_date = $Shamsi->parse("{$year}-{$month}-{$j} 23:59:59", true, ['format' => 'Y-m-d H:i:s']);

    $days_array .= "['". $year ."/". $month ."/{$j}'],\n";
    
    $data_array .= "['" . $Order->reportByRange($start_date, $end_date) . "'],\n";
}
?>
<div class="row">
    <div class="col-xl-12">

        <!--begin:: Widgets/Finance Summary-->
        <div class="m-portlet m-portlet--full-height m-portlet--fit ">
            <div class="m-portlet__head">
                <div class="m-portlet__head-caption">
                    <div class="m-portlet__head-title">
                        <h3 class="m-portlet__head-text">
                            نمودار پرداخت ماهانه
                        </h3>
                    </div>
                </div>
                <div class="m-portlet__head-tools">

                    <ul class="m-portlet__nav" id="month-picker">
                        <li class="m-portlet__nav-item m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                            <a href="javascript:" id="selected-value" data-value="<?= $month ?>" class="m-portlet__nav-link m-dropdown__toggle dropdown-toggle btn btn--sm m-btn--pill btn-secondary m-btn m-btn--label-brand">
                                <?= monthName($month)  ?>
                            </a>
                            <div class="m-dropdown__wrapper">
                                <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust" style="left: auto; right: 36.5px;"></span>
                                <div class="m-dropdown__inner">
                                    <div class="m-dropdown__body">
                                        <div class="m-dropdown__content">
                                            <ul class="m-nav">
                                                <li class="m-nav__item" data-value="01"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text">فروردین</span></a></li>
                                                <li class="m-nav__item" data-value="02"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text">اردیبهشت</span></a></li>
                                                <li class="m-nav__item" data-value="03"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >خرداد</span></a></li>
                                                <li class="m-nav__item" data-value="04"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >تیر</span></a></li>
                                                <li class="m-nav__item" data-value="05"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >مرداد</span></a></li>
                                                <li class="m-nav__item" data-value="06"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >شهریور</span></a></li>
                                                <li class="m-nav__item" data-value="07"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >مهر</span></a></li>
                                                <li class="m-nav__item" data-value="08"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >آبان</span></a></li>
                                                <li class="m-nav__item" data-value="09"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >آذر</span></a></li>
                                                <li class="m-nav__item" data-value="10"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >دی</span></a></li>
                                                <li class="m-nav__item" data-value="11"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >بهمن</span></a></li>
                                                <li class="m-nav__item" data-value="12"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text" >اسفند</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>

                    <ul class="m-portlet__nav" id="year-picker">
                        <li class="m-portlet__nav-item m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                            <a href="javascript" id="selected-value" data-value="<?= $year ?>" class="m-portlet__nav-link m-dropdown__toggle dropdown-toggle btn btn--sm m-btn--pill btn-secondary m-btn m-btn--label-brand">
                                <?= $year ?>
                            </a>
                            <div class="m-dropdown__wrapper">
                                <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust" style="left: auto; right: 36.5px;"></span>
                                <div class="m-dropdown__inner">
                                    <div class="m-dropdown__body">
                                        <div class="m-dropdown__content">
                                            <ul class="m-nav">
                                                <?php for ($i = $current_year; $i > $current_year - 5; $i--) : ?>
                                                    <li class="m-nav__item" data-value="<?= $i ?>"><a href="javascript:" class="m-nav__link"><span class="m-nav__link-text"><?= $i ?></span></a></li>
                                                <?php endfor; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>

                </div>
            </div>

            <div class="m-portlet__body">
                <div class="tab-content">
                    <div class="m-widget12 m-widget12--chart-bottom m--margin-top-10">
                        <div class="m-widget15__chart" style="height:320px;">
                            <canvas id="monthly-chart"></canvas>
                        </div>

                    </div>
                </div>
            </div>

        </div>

        <!--end:: Widgets/Finance Summary-->
    </div>
</div>