<?php

use Admin\Pagination;
use App\MessageBox;

require_once '../../../init.php';
require_once '../../../check_auth.php';
checkAccess('MAIL_MANAGE');

$adm_options = generalSettings();

$MessageBox = new MessageBox('sms');

$query = $MessageBox->inbox($loggedUser->USER_ID, true);

$total_count = $MessageBox->inboxCount($loggedUser->USER_ID);

$page = inputs()->not_empty('page') ? (int) input('page') : 1;

$per_page = $adm_options->MAIL_PER_PAGE;

$pagination= new Pagination($page, $per_page, $total_count);
$pagination->main_page='mailbox.php?';
$pagination->sql = $query;
$query = $pagination->correct_sql();

$mails = $MessageBox->find_by_sql($query, ['email']);
?>
<form name="multi_del_up" action="<?= adminroot() ?>process/pr_delete.php" method="POST" id="multi_del-up">
	<table class="table table-striped table-advance table-hover">
		<thead>
			<tr>
				<th class="text-right" colspan="6">
					<ul class="unstyled inline inbox-nav">
						<?php $pagination->show_ajax_pagination() ?>
					</ul>
				</th>
			</tr>
		</thead>
		<tbody>
			<?php
			if($mails)
			{
				/** @var MessageBox $mail */
				foreach ($mails as $mail)
				{
					$unread="";
					$users = explode(',',$mail->USERS_VIEWED);
					if(!in_array($loggedUser->USER_ID,$users)){
						$unread="class='unread'";
					}
			?>
				<tr <?= ( ! $mail->isViewedBy($loggedUser->USER_ID) ) ? "class='unread'" : false; ?>>

					<td class="inbox-small-cells" style="padding-top: 0;">
                        <label class="m-checkbox"><input type="checkbox" class="to-be-checked" value="<?= $mail->MESSAGE_ID ?>"><span></span></label>
                    </td>
					<td class="inbox-small-cells" style="font-size:10px"><?php echo not_empty($mail->REPLY_TO) ? "<i class='icon-share-alt' style='line-height:22px'></i>" : false ?></td>
					<td class="view-message  hidden-phone" 		name="<?php echo $mail->MESSAGE_ID ?>"><?php echo $mail->SENDER_NAME ?></td>
					<td class="view-message " 			   		name="<?php echo $mail->MESSAGE_ID ?>"><?php echo $mail->TITLE ?></td>
					<td class="view-message  inbox-small-cells" name="<?php echo $mail->MESSAGE_ID ?>"><i class="icon-paper-clip"></i></td>
					<td class="view-message  text-right"		name="<?php echo $mail->MESSAGE_ID ?>"><?php if($mail->DATE_CREATED > 0  && $mail->DATE_CREATED!==NULL) echo miladiToShamsiAdmin($mail->DATE_CREATED,"Y/m/d ساعت H:i") ?></td>
				</tr>
			<?php
				}
			}else{
			?>
				<tr>
					<td></td>
					<td colspan="6">هیچ رکوردی برای نمایش وجود ندارد</td>
				</tr>
			<?php
			}
			?>
		</tbody>
	</table>

	<!--=============== MODALS PART =================-->

	<!-- delete modal -->
	<div id="multi_del_mail_modal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel3" aria-hidden="true">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
			<h3 id="myModalLabel3" class="size-20"> <i class="icon-dollar"></i> حذف آیتم ها </h3>
		</div>
		<div class="modal-body">
			<p> آیا مایل به حذف آیتم های انتخاب شده هستید؟ </p>
		</div>
		<div class="modal-footer">
			<input type="hidden" name="action" value="bulk-delete-emails">
			<button class="btn red" data-dismiss="modal" aria-hidden="true">خیر</button>
			<button type="submit" class="btn green">بلی</button>
		</div>
	</div>
</form>

