<?php
use Admin\Ads;

use Admin\Pagination;
use App\Input;
use App\MessageBox;

require_once '../../../init.php';
require_once '../../../check_auth.php';
checkAccess('MAIL_MANAGE');

$adm_options = generalSettings();

$MessageBox = new MessageBox('email');

$query = $MessageBox->sent(true);
$total_count = $MessageBox->sentCount();

$page = inputs()->not_empty('page') ? (int) input('page') : 1 ;
$per_page = $adm_options->MAIL_PER_PAGE;

$pagination = new Pagination($page, $per_page, $total_count);
$pagination->main_page='mailbox.php?';
$pagination->sql = $query;
$query = $pagination->correct_sql();

$mails = $MessageBox->find_by_sql($query, ['email']);
?>
<form name="multi_del_up" action="<?= adminroot() ?>process/pr_delete.php" method="POST" id="multi_del-up">
	<table class="table table-striped table-advance table-hover">
		<thead>
			<tr>

				<th class="text-right" colspan="6">
					<ul class="unstyled inline inbox-nav">
						<?php $pagination->show_ajax_pagination('sent') ?>
					</ul>
				</th>
			</tr>
		</thead>
		<tbody>
			<?php
			if($mails)
			{
				foreach ($mails as $mail)
				{
				?>
					<tr>
                        <td class="inbox-small-cells" style="padding-top: 0;">
                            <label class="m-checkbox"><input type="checkbox" class="to-be-checked" value="<?= $mail->MESSAGE_ID ?>"><span></span></label>
                        </td>
						<td class="inbox-small-cells" style="font-size:10px"><?= not_empty($mail->REPLY_TO) ? "<i class='icon-share-alt' style='line-height:22px'></i>" : false ?></td>
						<td class="view-message  hidden-phone" 		name="<?= $mail->MESSAGE_ID ?>"><?= $mail->SENDER_NAME ?></td>
						<td class="view-message " 			   		name="<?= $mail->MESSAGE_ID ?>"><?= $mail->TITLE ?></td>
						<td class="view-message  inbox-small-cells" name="<?= $mail->MESSAGE_ID ?>"><i class="icon-paper-clip"></i></td>
						<td class="view-message  text-right"		name="<?= $mail->MESSAGE_ID ?>"><?php if($mail->DATE_CREATED > 0  && $mail->DATE_CREATED!==NULL) echo miladiToShamsiAdmin($mail->DATE_CREATED,"Y/m/d ساعت H:i") ?></td>
					</tr>
			<?php
				}
			}else{
			?>
				<tr>
					<td></td>
					<td colspan="4">هیچ رکوردی برای نمایش وجود ندارد</td>
				</tr>
			<?php
			}
			?>
		</tbody>
	</table>

</form>

