<?php

use App\MessageBox;

require_once '../../../init.php';
require_once '../../../check_auth.php';
checkAccess('MAIL_MANAGE');

$MessageBox = new MessageBox('email');

$mail = $MessageBox->byId(input('mailId'));
if( ! $mail ) {
	return false;
}
?>
<form class="inbox-compose form-horizontal" id="fileupload" action="<?= mailboxRoute('email') ?>" method="POST" enctype="multipart/form-data">
    <?= csrf_field() ?>
	<div class="inbox-compose-btn">
        <a href="<?= mailboxRoute('email') ?>" class="btn btn-secondary m-btn m-btn--custom m-btn--icon cancel">
            <span><i class="fa fa-arrow-right"></i><span>انصراف</span></span>
        </a>
        <button class="btn btn-info m-btn m-btn--custom m-btn--icon btn-xs">
            <span><i class="fa fa-check"></i><span>ارسال</span></span>
        </button>
	</div>
	<div class="inbox-control-group mail-to">
		<label for="to" class="control-label size-13">ارسال به :</label>
		<div class="controls controls-to">
			<input type="text" class="m-wrap span12" name="to" id="to" value="<?= $mail->SENDER_MAIL ?>">
		</div>
	</div>
	<div class="inbox-control-group">
		<label for="subject" class="control-label size-13">موضوع:</label>
		<div class="controls">
			<input type="text" class="m-wrap span12 YEKAN size-13" name="subject" id="subject" value="<?= $mail->TITLE ?>">
		</div>
	</div>
	<div class="inbox-control-group">
		<div class="controls-row">
			<textarea class="span12 inbox-editor inbox-wysihtml5 m-wrap" name="message" id="message" rows="12" title="message">
            </textarea>
			<div id="reply_email_content_body" class="hidden">
				<br>
				<br>
                ------------------------------------------------------------
				<blockquote>
					<?= $mail->MESSAGE ?>
				</blockquote>
			</div>
		</div>
	</div>



	<script id="template-upload" type="text/x-tmpl">
	</script>
	<script id="template-download" type="text/x-tmpl">

	</script>
	<div class="inbox-compose-btn">
        <a href="<?= mailboxRoute('email') ?>" class="btn btn-secondary m-btn m-btn--custom m-btn--icon cancel">
            <span><i class="fa fa-arrow-right"></i><span>انصراف</span></span>
        </a>
        <button class="btn btn-info m-btn m-btn--custom m-btn--icon btn-xs">
            <span><i class="fa fa-check"></i><span>ارسال</span></span>
        </button>
	</div>
	<input type="hidden" name="hi_is_reply" value="2">
	<input type="hidden" name="hi_mail_id" value="<?php echo $mail->MESSAGE_ID ?>">
</form>