<?php
use Admin\Ads;

use App\MessageBox;

require_once '../../../init.php';
require_once '../../../check_auth.php';
checkAccess('MAIL_MANAGE');

$MessageBox = new MessageBox('email');

$mail = $MessageBox->byId(input('mailId'));
if( ! $mail ) {
	return false;
}
$MessageBox->makeViewedBy($mail, $loggedUser->USER_ID);
?>
<div class="inbox-header inbox-view-header">
	<h1 class="pull-right"><?php echo $mail->TITLE ?></h1>
</div>
<div class="inbox-view-info row">
	<div class="col-lg-7">
		<!-- <img src="../images/logo.png" height="30" width="30">  -->
		فرستاده شده توسط
		<?php
		if($mail->FROM=="ADMIN"){
			echo "<span class='badge YEKAN size-13'> مدیریت سایت </span>";
		}else{
			echo "<span class='bold'> " . $mail->SENDER_MAIL . " </span>";
			echo not_empty($mail->USER_ID) ? "( شناسه کاربری : {$mail->USER_ID} )" : false ;
		}
		?>
		در  <?php if($mail->DATE_CREATED > 0  && $mail->DATE_CREATED!==NULL) echo miladiToShamsiAdmin($mail->DATE_CREATED,"Y/m/d ساعت H:i") ?> <br/>
		ارسال شده برای
		<?php
		if (not_empty($mail->RECIVER_MAIL)){
			$receivers=explode(',',$mail->RECIVER_MAIL);
			foreach ($receivers as $receiver) {
				echo "<span class='m-badge m-badge--square m-badge--mini'>{$receiver}</span>  " ;
			}
		} elseif (not_empty($mail->RECIVER_USER_ID)){

			$receivers = explode(',', $mail->RECIVER_USER_ID);
			foreach ($receivers as $receiver) {
				$user = $User->findById($receiver);
				echo "<a href='" . usersRoute('profile', $user->USER_ID) . "' target='_blank'><span class='m-badge m-badge--square m-badge--mini'>" . $user->username() . " </span></a> ، " ;
			}

		}elseif( $mail->RECIVER_USER_ID=="0" ){
			echo "<span class='badge YEKAN size-13' > همه کاربران </span>";
		}else{
			echo "<span class='badge YEKAN size-13' > مدیریت سایت </span>";
		}
		?>
	</div>
	<div class="col-lg-5 inbox-info-btn">
		<div class="btn-group">
            <button class="btn btn-info m-btn m-btn--custom m-btn--icon reply-btn">
                <span><i class="fa fa-reply"></i><span>ارسال پاسخ</span></span>
            </button>
		</div>
	</div>
</div>
<div class="inbox-view">
	<?php echo $mail->MESSAGE ?>
</div>
<hr>

