<?php

use App\LocationList;

/* @var App\Location $location */
?>
<div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
    <div class="m-portlet__body">
        <div class="m-portlet__body form-float-input">

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($location->name()) ?>">
                <input type="text" id="title" name="title" class="form-control" value="<?= $location->name() ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="title">نام منطقه (شهر یا استان)</label>
                <p class="help-block"></p>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($location->SLUG) ?>">
                <input type="text" id="slug" name="slug" class="form-control" value="<?= $location->SLUG ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="slug"><?php _e('SLUG') ?></label>
                <div class="help-block m-t-5">نامک وارد شده نباید قبلا برای منطقه دیگری استفاده شده باشد. بهتر است فقط از حروف لاتین استفاده نمایید. به عنوان مثال: Tehran</div>
            </div>

            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="state_id"><?php _e('STATE') ?></label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-map-marker-alt"></i> </span>
                        <select name="state_id" id="state_id" class="form-control advanced-select">
                            <option value="0"><?php _e('CHOOSE') ?></option>
                            <<?php
                            $LocationList = new LocationList();
                            $state_id = ($location->isState()) ? 0 : optional($location->state())->id();
                            /** @var App\Location $state */
                            foreach ($LocationList->states() as $state) {
                                echo "<option value='{$state->id()}' ". activeState($state_id, $state->id()) ." data-latitude='{$state->latitude}' data-longitude='{$state->longitude}'>{$state->name()}</option>";
                            }
                            ?>
                            ?>
                        </select>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="col-lg-6">

                </div>
            </div>

        </div>
    </div>
</div>