<?php
use App\Order;
?>

<!--begin:: Widgets/Stats-->
<div class="m-portlet  m-portlet--unair">
    <div class="m-portlet__body  m-portlet__body--no-padding">
        <div class="row m-row--no-padding m-row--col-separator-xl">

            <?php if (currentUser()->hasAccessTo('PAYMENT_VIEW')) : ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">پرداختی های جدید</h4><br>
                            <span class="m-widget24__desc">پرداخت های مشاهده نشده</span>
                            <span class="m-widget24__stats m--font-brand">
                                    <?php
                                    $Order = new Order();
                                    echo price_format($Order->newPayments());
                                    ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-brand" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change"></span>
                            <span class="m-widget24__number">
                                    <a class="more" href="<?= ordersRoute() ?>" target='_blank'>بیشتر </i></a>
                                </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (currentUser()->hasAccessTo('ADS_MANAGE')) : ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title"> آگهی های امروز</h4><br>
                            <span class="m-widget24__desc">تمام آگهی های روز جاری</span>
                            <span class="m-widget24__stats m--font-info">
                                    <?= $Ads->todayCreatedCount() ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-info" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change"></span>
                            <span class="m-widget24__number">
                                    <a class="more" href="<?= adsRoute(null, null, ['time' => 'today']) ?>" target='_blank'>بیشتر </a>
                                </span>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">در انتظار بررسی</h4><br>
                            <span class="m-widget24__desc">آگهی های تائید نشده</span>
                            <span class="m-widget24__stats m--font-danger">
                                    <?= $Ads->count_suspended_ads() ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-danger" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change"></span>
                            <span class="m-widget24__number">
                                    <a class="more" href="<?= adsRoute(null, null, ['status' => 5]) ?>" target='_blank'>بیشتر </a>
                                </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

        </div>
    </div>
</div>

<!--begin:: Widgets/Stats-->
<div class="m-portlet  m-portlet--unair">
    <div class="m-portlet__body  m-portlet__body--no-padding">
        <div class="row m-row--no-padding m-row--col-separator-xl">

            <?php if (currentUser()->hasAccessTo('ADS_MANAGE')) : ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title">منقضی</h4><br>
                            <span class="m-widget24__desc">آگهی های منقضی شده</span>
                            <span class="m-widget24__stats m--font-success">
                                        <?= $Ads->count_expired_ads() ?>
                                    </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-success" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change"></span>
                            <span class="m-widget24__number">
                                <a class="more" href="<?= adsRoute(null, null, ['status' => 4]) ?>" target='_blank'>بیشتر </a>
                            </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (currentUser()->hasAccessTo('PAYMENT_VIEW')) : ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title"> کاربران امروز </h4><br>
                            <span class="m-widget24__desc">کاربرانی که امروز ثبت نام کرده اند</span>
                            <span class="m-widget24__stats m--font-warning">
                                    <?= $User->todayCreatedCount(); ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-warning" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change"></span>
                            <span class="m-widget24__number">
                                    <a class="more" href="<?= usersRoute(null, null, ['time' => 'today']) ?>" target='_blank'>بیشتر </i></a>
                                </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (currentUser()->hasAccessTo('STATS_VIEW')) : ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="m-widget24">
                        <div class="m-widget24__item">
                            <h4 class="m-widget24__title"> بازدید کننده های امروز </h4><br>
                            <span class="m-widget24__desc">تعداد کل بازدیدهای روز جاری سایت</span>
                            <span class="m-widget24__stats m--font-accent">
                                    <?=  $stats->today()->HITS; ?>
                                </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-accent" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget24__change"></span>
                            <span class="m-widget24__number">
                                    <a class="more" href="<?= statisticsRoues() ?>" target='_blank'>بیشتر </i></a>
                                </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

        </div>
    </div>
</div>