<?php
if (isset($current_page) && ! empty($current_page)) {
    $current_page_title = $page_title ?: pageTitle($current_page);
    $current_page_description = $page_description ?: pageDescription($current_page);
    $current_page_keywords = $page_keywords ?: pageKeywords($current_page);
}
if (! isset($current_page_title)) {
    $current_page_title = setting('SEO_TITLE');
}

$author = isset($page_author) ? $page_author : setting('SITE_AUTHOR');
?>
    <meta name="robots" content="noindex">
    <meta charset="utf-8" />
    <title><?= $current_page_title ?></title>
    <meta name="description" content="بخش مدیریت">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <meta name="author" content="<?= setting('SITE_AUTHOR') ?>">

<?php if (! isset($set_base) || $set_base) : ?>
    <base href="<?= adminroot() ?>">
<?php endif; ?>

    <link href="assets/final/css/vendors.css" rel="stylesheet" type="text/css" />

<?php if (isset($page__has_maps) && $page__has_maps) : ?>
    <?php if (isLeafletMaps() && ! isNeshanMaps()) : ?>
<link rel="stylesheet" href="../node_modules/leaflet/dist/leaflet.css" integrity="sha512-puBpdR0798OZvTTbP4A8Ix/l+A4dHDD0DGqYW6RQ+9jxkRFclaxxQb/SJAWZfWAkuyeQUytO7+7N4QKrDh+drA==" crossorigin=""/>
    <?php endif; ?>
    <?php if (isNeshanMaps()) : ?>
<link rel="stylesheet" type="text/css" href="../public/lib/neshan-maps/neshan-leaflet.css">
    <?php endif; ?>
<?php endif; ?>

    <!--end:: Global Optional Vendors -->

<?php
if (isset($load_before_main_style) && is_array($load_before_main_style)) {
    foreach ($load_before_main_style as $style) {
        echo "<link rel='stylesheet' href='{$style}'> \n";
    }
}
?>

    <link rel="stylesheet" href="assets/final/css/styles.css">

<?php
if (isset($load_after_main_style) && is_array($load_after_main_style)) {
    foreach ($load_after_main_style as $style) {
        echo "<link rel='stylesheet' href='{$style}'> \n";
    }
}
?>



<?php include 'favicons.php' ?>