<?php
/** @var App\Coupon $coupon */
?>
<div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
    <div class="m-portlet__body">
        <div class="m-portlet__body form-float-input">

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($coupon->title) ?>">
                <input type="text" id="title" name="title" class="form-control" value="<?= $coupon->title ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="name">عنوان <span class="required ltr"> * </span></label>
                <p class="help-block"></p>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($coupon->code) ?>">
                <input type="text" id="code" name="code" class="form-control" value="<?= $coupon->code ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="code">کد تخفیف <span class="required ltr"> * </span></label>
                <p class="help-block m-t-10"> کد تخفیف را با حروف لاتین وارد نمایید به عنوان مثال: test</p>
            </div>

            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="type">نوع تخفیف </label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-cart-plus"></i> </span>
                        <select name="type" id="type" class="form-control advanced-select" data-category-selector data-child-selector="#subcategory_id" data-child-type="subcategory">
                            <option value="cart-percent" <?= activeState($coupon->type, 'cart-percent') ?>>درصد تخفیف</option>
                            <option value="cart-price"   <?= activeState($coupon->type, 'cart-price') ?>>تخفیف ثابت </option>
                        </select>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon <?= groupActiveState($coupon->discount) ?>">
                        <input type="text" id="discount" name="discount" class="form-control digits-field" value="<?= $coupon->discount ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-cart-plus"></i> </span>
                        <label for="discount">میزان تخفیف <span class="required ltr"> * </span></label>
                        <p class="help-block m-t-10"> مبلغ تخفیف (<?= setting('CURRENCY') ?>) یا درصد تخفیف را وارد نمایید</p>
                        <div class="digits-divider"></div>
                    </div>
                </div>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($coupon->description) ?>">
                <textarea name="description" id="description" class="form-control medium"><?= $coupon->description ?></textarea>
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="description">توضیحات دلخواه </label>
                <p class="help-block"></p>
            </div>

        </div>
    </div>
</div>