<?php

use App\Category;
use App\SubCategory;

?>
<div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
    <div class="m-portlet__body">
        <div class="m-portlet__body form-float-input">

            <div class="form-group form-group--float form-group--icon <?= groupActiveState( $current_category->name()) ?>">
                <input type="text" id="name" name="name" class="form-control" value="<?=  $current_category->name() ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="name">عنوان</label>
                <p class="help-block"></p>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($current_category->slug()) ?>">
                <input type="text" id="slug" name="slug" class="form-control" value="<?= $current_category->slug() ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="slug">نامک</label>
                <p class="help-block"></p>
            </div>

            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="category_id">دسته مادر</label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                        <select name="category_id" id="category_id" class="form-control advanced-select" data-category-selector data-child-selector="#subcategory_id" data-child-type="subcategory">
                            <option value="0" selected="selected"><?php _e('CHOOSE') ?></option>
                            <?php
                            $Category = new Category();
                            $categories = $Category->lists(false);
                            foreach ($categories as $category) {
                                echo "<option value='{$category->ID}' " . activeState($category->ID, $current_category->parentCategoryId()) . ">{$category->CATEGORY_NAME}</option>";
                            }
                            ?>
                        </select>
                        <p class="help-block"></p>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="subcategory_id">زیردسته مادر</label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                        <select name="subcategory_id" id="subcategory_id" class="form-control advanced-select">
                            <option value="0" selected="selected"><?php _e('CHOOSE') ?></option>
                            <?php
                            if ($current_category->type() !== 'category') {
                                $SubCategory = new SubCategory();
                                $subcategories = $SubCategory->firstTireForCategory($current_category->parentCategoryId(), $current_category->ID, false);
                                foreach ($subcategories as $subcategory) {
                                    echo "<option value='{$subcategory->ID}' ". activeState($subcategory->ID, $current_category->parentId()) .">{$subcategory->SUBCATEGORY_NAME}</option>";
                                }
                            }
                            ?>
                        </select>
                        <p class="help-block"></p>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="extra_description"><h5><?php _e('ADS_DESCRIPTION') ?>:</h5> </label>
                <textarea type="text" name="extra_description" id="extra_description"><?= $current_category->extraDescription() ?></textarea>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($current_category->seoTitle()) ?>">
                <input type="text" id="seo_title" name="seo_title" class="form-control" value="<?= $current_category->seoTitle() ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-map-pin"></i> </span>
                <label for="seo_title"><?php _e('SEO_TITLE') ?></label>
                <p class="help-block"></p>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($current_category->description()) ?>">
                <textarea name="description" id="description" class="form-control medium"><?= $current_category->description() ?></textarea>
                <span class="input-icon-addon top-3"> <i class="fa fa-map-pin"></i> </span>
                <label for="description">توضیحات دسته (سئو :: تگ description) </label>
            </div>

            <div class="form-group form-group--float form-group--icon <?= groupActiveState($current_category->keywords()) ?>">
                <textarea name="keywords" id="keywords" class="form-control medium"><?= $current_category->keywords() ?></textarea>
                <span class="input-icon-addon top-3"> <i class="fa fa-map-pin"></i> </span>
                <label for="keywords"> کلمات کلیدی (سئو :: تگ keywords) </label>
            </div>

        </div>
    </div>
</div>