<div class="widget-creator">
    <div class="level widget-creator-header">
        <div class="title">
            ابزارک ها
        </div>
        <div class="actions">
            <i class="fa fa-plus  show-widgets-list-btn" v-show="! isSelectingWidget" @click.prevent="showWidgetsList"></i>
            <i class="fa fa-times hide-widgets-list-btn" v-show="isSelectingWidget"   @click.prevent="hideWidgetsList"></i>

            <a href="#" class="btn btn-accent btn-sm save-all-btn" @click.prevent="store"><i class="fa" :class="{ 'fa-check' : ! isLoading, 'fa-spinner fa-spin': isLoading }"></i> {{ isLoading ? 'در حال ذخیره سازی ...' : 'ذخیره ابزارک ها' }} </a>
        </div>
    </div>


    <div class="widget-selector" v-if="isSelectingWidget">
        <div class="widget-item" v-for="widget in widgets" :key="widget.slug" @click="addToActiveWidgets(widget)">
            <i class="fa" :class="widget.icon"></i> {{ widget.name }}
        </div>
    </div>

    <div class="active-widgets-list m-accordion m-accordion--default m-accordion--solid">

        <div class="overlay" v-show="isSelectingWidget"></div>

        <draggable v-model="active_widgets"
                   @start="drag=true"
                   @end="drag=false"
                   item-key="UUID">

                    <template #item="{element}">
                        <div class="active-widget-item m-accordion__item">
                            <div class="m-accordion__item-head active-widget-header" :class="{ collapsed: ! element.open }" :aria-expanded="element.open" @click.prevent="toggleWidget(element)">
                                <span class="m-accordion__item-icon"><i class="fa" :class="element.icon"></i></span>
                                <span class="m-accordion__item-title">{{ element.name }}</span>
                                <span class="m-accordion__item-mode"></span>
                            </div>
                            <div class="m-accordion__item-body collapse" :class="{ show: element.open }">
                                <div class="m-accordion__item-content active-widget-content">
                                    <div class="widget-description">
                                        {{ element.description }}
                                    </div>
                                    <div class="widget-fields">
                                        <div class="widget-field-item" v-for="field in element.fields" :key="field.slug">

                                            <div class="form-group form-group--float form-group--active" v-if="field.type === 'text'">
                                                <input type="text" :name="field.slug" class="form-control" v-model="field.default_value">
                                                <label>{{ field.title }}</label>
                                                <p class="help-block">{{ field.description }}</p>
                                            </div>

                                            <div class="form-group select-group--float form-group--float form-group--active select-group-simple" v-if="field.type === 'boolean'">
                                                <label>{{ field.title }}</label>
                                                <select :name="field.slug" v-model="field.default_value" class="form-control">
                                                    <option value="YES">بله</option>
                                                    <option value="NO">خیر</option>
                                                </select>
                                                <p class="help-block"></p>
                                            </div>

                                            <div class="form-group form-group--float form-group--active" v-if="field.type === 'textarea'">
                                                <textarea :name="field.slug" class="form-control medium ltr" v-model="field.default_value"></textarea>
                                                <label>{{ field.title }}</label>
                                                <p class="help-block">{{ field.description }}</p>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="m-accordion__item-footer widget-footer level">
                                    <a href="#" @click.prevent="removeWidget(element)" class="remove-widget-btn"><i class="fa fa-times"></i> حذف ابزارک</a>
                                </div>
                            </div>

                        </div>
                    </template>
        </draggable>

    </div>


</div>