<?php

use App\Comment;
use App\ExpiryEmail;
use App\MessageBox;
use App\WithdrawalRequest;
use App\Shamsi;

$Shamsi = new Shamsi('Y-m-d');

$current_month_stats = $stats->thisMonth();
?>
<div class="row">
    <div class="col-xl-4">

        <!--begin:: Widgets/New Users-->
        <div class="m-portlet m-portlet--full-height  m-portlet--unair">
            <div class="m-portlet__head">
                <div class="m-portlet__head-caption">
                    <div class="m-portlet__head-title">
                        <h3 class="m-portlet__head-text">
                            تازه ترین آگهی ها
                        </h3>
                    </div>
                </div>
                <div class="m-portlet__head-tools">
                    <ul class="nav nav-pills nav-pills--brand m-nav-pills--align-right m-nav-pills--btn-pill m-nav-pills--btn-sm"
                        role="tablist">
                        <li class="nav-item m-tabs__item">
                            <a class="nav-link m-tabs__link" data-toggle="tab" href="#suspended_tab" role="tab">در
                                حال بررسی</a>
                        </li>
                        <li class="nav-item m-tabs__item">
                            <a class="nav-link m-tabs__link active" data-toggle="tab" href="#approved_tab" role="tab">تایید
                                شده</a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="m-portlet__body">
                <div class="tab-content">
                    <div class="tab-pane" id="suspended_tab">
                        <div class="m-widget4">
                            <?php
                            $adss = $Ads->latestItems('suspended', 5);
                            foreach ($adss as $ads) {
                                include('includes/index/_ads_component.php');
                            }
                        ?>
                        </div>

                    </div>
                    <div class="tab-pane active" id="approved_tab">
                        <div class="m-widget4">
                            <?php
                            $adss = $Ads->latestItems('approved', 5);
                            foreach ($adss as $ads) {
                                include('includes/index/_ads_component.php');
                            }
                            ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-4">
        <!--begin:: Widgets/Inbound Bandwidth-->
        <div class="m-portlet m-portlet--bordered-semi m-portlet--half-height m-portlet--fit  m-portlet--unair"
             style="min-height: 300px">
            <div class="m-portlet__head">
                <div class="m-portlet__head-caption">
                    <div class="m-portlet__head-title">
                        <h3 class="m-portlet__head-text">
                            بازدیدهای ماهانه
                        </h3>
                    </div>
                </div>
                <div class="m-portlet__head-tools">
                    <ul class="m-portlet__nav">
                        <li class="m-portlet__nav-item m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push">
                            <a class="m-portlet__nav-link btn btn--sm m-btn--pill btn-secondary m-btn m-btn--label-brand">
                                <?= $Shamsi->currentMonthName() ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="m-portlet__body">
                <div class="m-widget20">
                    <?php
                    $monthlyChartPageViews = $monthlyChartVisitors = $days_array = "";
                    $endDay = $Shamsi->currentMonthDays();

                    for ($i = 1; $i <= $endDay; $i++) {

                        $j = ($i < 10) ? "0".$i : $i;

                        $shamsi_date = $Shamsi->currentYear() . '-' . $Shamsi->currentMonth() . '-' . $j;
                        $date = $Shamsi->parse($shamsi_date, true);
                        $day_stat = $stats->forDate($date);

                        $days_array .= "['". $Shamsi->currentYear() ."/". $Shamsi->currentMonth() ."/{$j}'],\n";
                        $daily_hits_array .= "['" . (int) $day_stat->HITS . "'],\n";
                        $daily_unique_hits_array .= "['" . (int) $day_stat->UNIQUE_HITS . "'],\n";
                    }
                    ?>
                    <div class="m-widget20__number m--font-success"><?= $current_month_stats->HITS ?></div>
                    <div class="m-widget20__chart" style="height:160px;">
                        <canvas id="monthly-chart-hits"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!--end:: Widgets/Inbound Bandwidth-->
        <div class="m--space-30"></div>

        <!--begin:: Widgets/Outbound Bandwidth-->
        <div class="m-portlet m-portlet--bordered-semi m-portlet--half-height m-portlet--fit  m-portlet--unair"
             style="min-height: 300px">
            <div class="m-portlet__head">
                <div class="m-portlet__head-caption">
                    <div class="m-portlet__head-title">
                        <h3 class="m-portlet__head-text">
                            بازدیدهای یکتای ماهانه
                        </h3>
                    </div>
                </div>
                <div class="m-portlet__head-tools">
                    <ul class="m-portlet__nav">
                        <li class="m-portlet__nav-item m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push">
                            <a class="m-portlet__nav-link btn btn--sm m-btn--pill btn-secondary m-btn m-btn--label-brand">
                                <?= $Shamsi->currentMonthName() ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="m-portlet__body">

                <!--begin::Widget5-->
                <div class="m-widget20">
                    <div class="m-widget20__number m--font-warning"><?= $current_month_stats->UNIQUE_HITS ?></div>
                    <div class="m-widget20__chart" style="height:160px;">
                        <canvas id="monthly-chart-unique-hits"></canvas>
                    </div>
                </div>

                <!--end::Widget 5-->
            </div>
        </div>

        <!--end:: Widgets/Outbound Bandwidth-->
    </div>
    <div class="col-xl-4">

        <!--begin:: Widgets/Top Products-->
        <div class="m-portlet m-portlet--full-height m-portlet--fit  m-portlet--unair">
            <div class="m-portlet__head">
                <div class="m-portlet__head-caption">
                    <div class="m-portlet__head-title">
                        <h3 class="m-portlet__head-text">
                            پربازدیدترین آگهی ها
                        </h3>
                    </div>
                </div>
            </div>
            <div class="m-portlet__body">
                <div class="m-widget4 m-widget4--chart-bottom" style="min-height: 480px">
                    <?php
                    $adss = $Ads->mostViewed(6);
                    foreach ($adss as $ads) :
                        /** @var Admin\Ads $ads */
                        ?>
                        <div class="m-widget4__item">
                            <div class="m-widget4__img m-widget4__img--logo">
                                <img src="<?= $ads->featuredImage('thumb') ?>" alt="">
                            </div>
                            <div class="m-widget4__info">
                                <span class="m-widget4__title"><a href="<?= $ads->shortLink() ?>"
                                                                  target="_blank"><?= $ads->ADS_TITLE ?></a></span><br>
                                <span class="m-widget4__sub star-rate-field"><?= $ads->star_rate() ?></span>
                            </div>
                            <span class="m-widget4__ext">
                                <span class="m-widget4__number m--font-brand"><?= number_format($ads->VIEWS) ?> بازدید</span>
                            </span>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!--end::Widget 5-->
            </div>
        </div>

        <!--end:: Widgets/Top Products-->
    </div>
</div>

<div class="row">
    <div class="col-xl-6">
        <div class="m-portlet m-portlet--bordered-semi m-portlet--space m-portlet--full-height ">
            <div class="m-portlet__head">
                <div class="m-portlet__head-caption">
                    <div class="m-portlet__head-title">
                        <h3 class="m-portlet__head-text">
                            آمار ماهیانه
                            <span class="m-portlet__head-desc"> مقایسه نسبت به ماه گذشته </span>
                        </h3>
                    </div>
                </div>
                <div class="m-portlet__head-tools">
                    <ul class="m-portlet__nav">
                        <li class="m-portlet__nav-item m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push">
                            <a class="m-portlet__nav-link btn btn--sm m-btn--pill btn-secondary m-btn m-btn--label-brand">
                                <?= $Shamsi->currentMonthName() ?>
                                <?php
                                $current_month = $Shamsi->currentMonthDetails();
                                $previous_month = $Shamsi->previousMonthDetails();

                                $current_month_income = $Order->reportByRange(data_get($current_month, 'month_start'), data_get($current_month, 'month_end'));
                                $previous_month_income = $Order->reportByRange(data_get($previous_month, 'month_start'), data_get($previous_month, 'month_end'));

                                $current_month_ads = $Ads->countByRange(data_get($current_month, 'month_start'), data_get($current_month, 'month_end'));
                                $previous_month_ads = $Ads->countByRange(data_get($previous_month, 'month_start'), data_get($previous_month, 'month_end'));

                                $current_month_users = $User->countByRange(data_get($current_month, 'month_start'), data_get($current_month, 'month_end'));
                                $previous_month_users = $User->countByRange(data_get($previous_month, 'month_start'), data_get($previous_month, 'month_end'));

                                $income_percentage = ceil(calculateIncrementPercentage($current_month_income, $previous_month_income));
                                $ads_percentage = ceil(calculateIncrementPercentage($current_month_ads, $previous_month_ads));
                                $users_percentage = ceil(calculateIncrementPercentage($current_month_users, $previous_month_users));
                                ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="m-portlet__body">
                <div class="m-widget25">
                    <span class="m-widget25__price m--font-brand"><?= price_format($current_month_income) ?></span>
                    <span class="m-widget25__desc">درآمد ماه جاری</span>
                    <div class="m-widget25--progress">
                        <div class="m-widget25__progress">
                            <span class="m-widget25__progress-number">
                                <?= abs($income_percentage) ?>%
                                <?php if ($income_percentage != 0) : ?>
                                <small class="difference-status <?= ($income_percentage > 0) ? 'm--font-success' : 'm--font-danger' ?>"><?= ($income_percentage > 0) ? "<i class='fa fa-caret-up'></i> افزایش" : "<i class='fa fa-caret-down'></i> کاهش" ?></small>
                                <?php endif; ?>
                            </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-danger" role="progressbar" style="width: <?= abs($income_percentage) ?>%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget25__progress-sub">اختلاف درآمد</span>
                        </div>
                        <div class="m-widget25__progress">
                            <span class="m-widget25__progress-number">
                                <?= abs($ads_percentage) ?>%
                                <?php if ($ads_percentage != 0) : ?>
                                    <small class="difference-status <?= ($ads_percentage > 0) ? 'm--font-success' : 'm--font-danger' ?>"><?= ($ads_percentage > 0) ? "<i class='fa fa-caret-up'></i> افزایش" : "<i class='fa fa-caret-down'></i> کاهش" ?></small>
                                <?php endif; ?>
                            </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-accent" role="progressbar" style="width: <?= abs($ads_percentage) ?>%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget25__progress-sub">تعداد آگهی های ثبت شده</span>
                        </div>
                        <div class="m-widget25__progress">
                            <span class="m-widget25__progress-number">
                                <?= abs($users_percentage) ?>%
                                <?php if ($users_percentage != 0) : ?>
                                    <small class="difference-status <?= ($users_percentage > 0) ? 'm--font-success' : 'm--font-danger' ?>"><?= ($users_percentage > 0) ? "<i class='fa fa-caret-up'></i> افزایش" : "<i class='fa fa-caret-down'></i> کاهش" ?></small>
                                <?php endif; ?>
                            </span>
                            <div class="m--space-10"></div>
                            <div class="progress m-progress--sm">
                                <div class="progress-bar m--bg-warning" role="progressbar" style="width: <?= abs($ads_percentage) ?>%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span class="m-widget25__progress-sub">
                                تعداد ثبت نام کاربران
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-6">
        <div class="m-portlet m-portlet--full-height ">
            <div class="m-portlet__head">
                <div class="m-portlet__head-caption">
                    <div class="m-portlet__head-title">
                        <h3 class="m-portlet__head-text">
                            سایر آمارها
                        </h3>
                    </div>
                </div>
            </div>
            <div class="m-portlet__body">

                <!--begin::widget 12-->
                <div class="m-widget4">
                    <div class="m-widget4__item">
                        <div class="m-widget4__ext">
                            <span class="m-widget4__icon m--font-brand">
                                <i class="flaticon-envelope m--font-primary"></i>
                            </span>
                        </div>
                        <div class="m-widget4__info">
                            <span class="m-widget4__text">
                                تعداد پیام های خوانده نشده <small>(طی ۷ روز گذشته)</small>
                            </span><br>
                            <small><a href="<?= mailboxRoute('email') ?>" target="_blank">بیشتر</a></small>
                        </div>
                        <div class="m-widget4__ext">
                            <span class="m-widget4__number m--font-info">
                                <?php
                                $MessageBox = new MessageBox('email');
                                echo $MessageBox->unreadCountFor(currentUser()->USER_ID);
                                ?>
                            </span>
                        </div>
                    </div>
                    <div class="m-widget4__item">
                        <div class="m-widget4__ext">
                            <span class="m-widget4__icon m--font-brand">
                                <i class="flaticon-multimedia m--font-success"></i>
                            </span>
                        </div>
                        <div class="m-widget4__info">
                            <span class="m-widget4__text">
                                ایمیل های در حال انتظار انقضای آگهی ها
                            </span><br>
                            <small><a href="<?= expireMessagesRoute('email') ?>" target="_blank">بیشتر</a></small>
                        </div>
                        <div class="m-widget4__ext">
                            <span class="m-widget4__number m--font-info">
                                <?php
                                $ExpiryEmails = new ExpiryEmail();
                                echo $ExpiryEmails->count();
                                ?>
                            </span>
                        </div>
                    </div>

                    <div class="m-widget4__item">
                        <div class="m-widget4__ext">
                            <span class="m-widget4__icon">
                                <i class="flaticon-coins  m--font-warning"></i>
                            </span>
                        </div>
                        <div class="m-widget4__info">
                            <span class="m-widget4__text">
                                 دیدگاه های در انتظار بررسی
                            </span><br>
                            <small><a href="<?= commentsRoute(null, null, 'ads') ?>" target="_blank">بیشتر</a></small>
                        </div>
                        <div class="m-widget4__ext">
                            <span class="m-widget4__number m--font-info">
                                <?php
                                $Comment = new Comment();
                                echo $Comment->suspendedCount();
                                ?>
                            </span>
                        </div>
                    </div>

                    <div class="m-widget4__item">
                        <div class="m-widget4__ext">
                            <span class="m-widget4__icon">
                                <i class="flaticon-coins  m--font-warning"></i>
                            </span>
                        </div>
                        <div class="m-widget4__info">
                            <span class="m-widget4__text">
                                 درخواست های برداشت وجه
                            </span><br>
                            <small><a href="<?= withdrawalRoute() ?>" target="_blank">بیشتر</a></small>
                        </div>
                        <div class="m-widget4__ext">
                            <span class="m-widget4__number m--font-info">
                                <?php
                                $WithdrawalRequest = new WithdrawalRequest();
                                echo $WithdrawalRequest->count('suspended');
                                ?>
                            </span>
                        </div>
                    </div>

                    <div class="m-widget4__item">
                        <div class="m-widget4__ext">
                            <span class="m-widget4__icon m--font-brand m--font-warning">
                                <i class="socicon-android  m--font-accent"></i>
                            </span>
                        </div>
                        <div class="m-widget4__info">
                            <span class="m-widget4__text">
                                 تعداد دانلودهای اپلیکیشن اندروید
                            </span><br>
                        </div>
                        <div class="m-widget4__ext">
                            <span class="m-widget4__number m--font-info">
                                <?= number_format(setting('ANDROID_DOWNLOADS_COUNT')) ?>
                            </span>
                        </div>
                    </div>
                </div>

                <!--end::Widget 12-->
            </div>
        </div>
    </div>
</div>

<!--End::Section-->

