<?php
use App\CategoryList;
use App\SubCategory;
?>
<div class="m-portlet m-portlet--full-height m-portlet--unair">
    <div class="m-portlet__body">
        <div id="sidebar-menu">
            <a href="#addModal" role="button" data-toggle="modal" class="btn btn-info m-btn m-btn--icon btn-lg btn-block">
                <span><i class="la la-plus"></i><span>افزودن بنر جدید</span></span>
            </a>

            <div class="m-portlet__body-separator"></div>

            <h4>فیلتر</h4>

            <div class="m-t-10">&nbsp;</div>

            <div class="form-group select-group--float form-group--float form-group--icon">
                <label for="filter_category_id"> دسته بندی </label>
                <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                <select name="filter_category_id" id="filter_category_id" class="form-control advanced-select">
                    <option value="0"> -- انتخاب کنید --</option>
                    <?php
                    $CategoryList = new CategoryList();
                    $categories = $CategoryList->categories();
                    /** @var App\Category $category */
                    foreach ($categories as $category) {
                        echo "<option value='{$category->ID}' ". activeState($category->ID, input('filter_category_id')) .">{$category->CATEGORY_NAME}</option>";
                    }
                    ?>
                </select>
            </div>

            <div class="form-group select-group--float form-group--float form-group--icon">
                <label for="filter_subcategory_id">زیردسته </label>
                <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                <select name="filter_subcategory_id" id="filter_subcategory_id" class="form-control advanced-select">
                    <option value="0"> همه</option>
                    <?php
                    if (inputs()->not_empty('filter_category_id')) {
                        $SubCategory = new SubCategory();
                        $subcategories = $SubCategory->firstTireForCategory(input('filter_category_id'));
                        foreach ($subcategories as $subcategory) {
                            echo "<option value='{$subcategory->ID}' ". activeState($subcategory->ID, input('filter_subcategory_id')) .">{$subcategory->SUBCATEGORY_NAME}</option>";
                        }
                    }
                    ?>
                </select>
            </div>

            <div class="form-group select-group--float form-group--float form-group--icon">
                <label for="filter_subsidiary_id">گروه </label>
                <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                <select name="filter_subsidiary_id" id="filter_subsidiary_id" class="form-control advanced-select">
                    <option value="0"> همه</option>
                    <?php
                    if (inputs()->not_empty('filter_subcategory_id')) {
                        $SubCategory = new SubCategory();
                        $subsidiaries = $SubCategory->subsidiariesFor(input('filter_subcategory_id'));

                        foreach ($subsidiaries as $subsidiary) {
                            echo "<option value='{$subsidiary->ID}' ". activeState($subsidiary->ID, input('filter_subsidiary_id')) .">{$subsidiary->SUBCATEGORY_NAME}</option>";
                        }
                    }
                    ?>
                </select>
            </div>


            <a href="javascript:" class="btn btn-secondary m-btn m-btn--icon btn-block" id="reset-filter">
                <span><i class="la la-remove"></i><span>پاکسازی فیلتر</span></span>
            </a>
        </div>
    </div>
</div>