<?php
use App\Banner;
?>

<div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">
    <div class="m-portlet__head">
        <div class="m-portlet__head-wrapper">
            <?php include 'includes/portlet_header.php' ?>
            <?php include 'includes/help_button.php' ?>
        </div>
    </div>
</div>


<?php
$category_id    = (inputs()->not_empty('filter_category_id'))    ? input('filter_category_id')     : 0;
$subcategory_id = (inputs()->not_empty('filter_subcategory_id')) ? input('filter_subcategory_id')  : 0;
$subsidiary_id  = (inputs()->not_empty('filter_subsidiary_id'))  ? input('filter_subsidiary_id')   : 0;

$i = $j = 1;
$Banner = new Banner();
$banners = $Banner->filter($category_id, $subcategory_id, $subsidiary_id);

/** @var Banner $banner */
foreach ($banners AS $banner) :
?>
<form method="post" enctype="multipart/form-data" action="<?= bannersRoute('adv', 'update', $banner->ID) ?>" >
    <div class="m-portlet m-portlet--last  portlet--accent m-portlet--head-lg m-portlet--responsive-mobile m-t-20" id="main-fields-wrapper">
        <div class="m-portlet__head">

            <?= csrf_field() ?>
            <input type="hidden" name="id" value="<?= $banner->ID ?>">

            <div class="m-portlet__head-wrapper">
                <div class="m-portlet__head-caption">
                    <div class="m-portlet__head-title">
                        <h3 class="m-portlet__head-text">
                            <?php
                            if ($banner->isForContent()) {
                                echo "بنر شماره {$i} - {$banner->WIDTH} در {$banner->HEIGHT} ";
                            } else {
                                echo "بنر سایدبار شماره  {$j} ";
                            }
                            ?>
                        </h3>
                         &nbsp; (<small>شناسه بنر: <?= $banner->ID ?></small>)
                    </div>
                </div>

                <div class="m-portlet__head-tools">
                    <a href="javascript:" class="btn btn-danger m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10" data-confirm-show--link data-link="<?= bannersRoute('adv', 'delete', $banner->ID) ?>">
                        <i class="la la-remove"></i>حذف بنر
                    </a>

                    <div class="btn-group">
                        <button type="submit" class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                            <i class="la la-check"></i>ذخیره تغییرات
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="m-portlet__body">
            <div class="row">
                <div class="col-lg-9">

                    <div class="form-group form-group--float form-group--icon form-group--active">
                        <input type="text" id="BANNER_DESC_<?= $i ?>" name="BANNER_DESC" class="form-control"  value="<?= $banner->BANNER_DESC ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                        <label for="BANNER_DESC_<?= $i ?>"> توضیح تبلیغ</label>
                        <div class="help-block"></div>
                    </div>

                    <div class="m-t-20">&nbsp;</div>
                    
                    <div class="form-group form-group--float form-group--icon form-group--active ">
                        <input type="text" id="link_<?= $i ?>" name="BANNER_LINK" class="form-control ltr foreign"  value="<?= $banner->BANNER_LINK ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-link"></i> </span>
                        <label for="link_<?= $i ?>"> لینک مرتبط با تبلیغ </label>
                        <div class="help-block m-t-5"> در صورت کلیک بر روی بنر ، به این لینک هدایت خواهید شد </div>
                    </div>

                    <div class="m-t-20">&nbsp;</div>

                    <div class="m--margin-bottom-10-tablet-and-mobile">
                        <label for="WILL_EXPIRE_<?= $i ?>">دارای زمان بندی باشد؟</label>
                        <select class="form-control m-bootstrap-select selectpicker will-expire" data-target="#EXPIRES_AT_<?= $banner->ID ?>" name="WILL_EXPIRE" id="WILL_EXPIRE_<?= $i ?>">
                            <option value="1" <?= activeState($banner->WILL_EXPIRE, 1) ?>>بلی</option>
                            <option value="0" <?= activeState($banner->WILL_EXPIRE, 0) ?>>خیر</option>
                        </select>
                    </div>

                    <div class="m-t-20">&nbsp;</div>

                    <div id="EXPIRES_AT_<?= $banner->ID ?>" style="<?= (! $banner->shouldBeExpired()) ? 'display: none' : false ?>">

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group form-group--float form-group--icon form-group--active">
                                    <input type="text" id="STARTS_AT_<?= $i ?>" name="STARTS_AT" class="form-control date-picker ltr" value="<?= miladiToShamsiAdmin($banner->STARTS_AT, 'Y/m/d', false) ?>">
                                    <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                                    <label for="STARTS_AT_<?= $i ?>"> تاریخ شروع بنر </label>
                                    <div class="help-block"></div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group form-group--float form-group--icon form-group--active">
                                    <input type="text" id="EXPIRES_AT_<?= $i ?>" name="EXPIRES_AT" class="form-control date-picker ltr" value="<?= miladiToShamsiAdmin($banner->EXPIRES_AT, 'Y/m/d', false) ?>">
                                    <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                                    <label for="EXPIRES_AT_<?= $i ?>"> تاریخ انقضای بنر </label>
                                    <div class="help-block"></div>
                                </div>
                            </div>
                        </div>

                    </div>
                    
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    فرمت تصویر باید jpg و یا gif باشد<br>
                    بهترین حالت نمایش این تبلیغ برای تصاویر با عرض <?= $banner->WIDTH ?> و ارتفاع <?= $banner->HEIGHT ?> می باشد
                </div>
                <div class="col-lg-10 m-t-20">
                    <div class="single-image-upload-preview" id="upload-banner-<?= $i ?>" data-width="<?= $banner->WIDTH ?>" data-height="<?= $banner->HEIGHT ?>" data-default-image="<?= $banner->imageUrl(); ?>">
                        <div class="imagePreview"></div>
                        <label class="btn btn-primary btn-block">
                            تغییر تصویر
                            <input type="file" class="uploadFile img" name="imageUpload">
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<?php
$i++;
if ($banner->POSITION === "SIDEBAR") {
    $j++;
}
endforeach;
?>