<?php

use App\Category;
use App\Plan;

?>
<form class="m-form m-form--fit m--margin-bottom-20">
    <div class="row m--margin-bottom-20">
        <div class="col-lg-2 m--margin-bottom-20-desktop m--margin-bottom-10-tablet-and-mobile">
            <label for="id">شناسه :</label>
            <input type="text" name="id" id="id" class="form-control m-input" value="<?= input('id') ?>">
        </div>
        <div class="col-lg-2 m--margin-bottom-20-desktop m--margin-bottom-10-tablet-and-mobile">
            <label for="title">عنوان:</label>
            <input type="text" name="title" id="title" class="form-control m-input" value="<?= input('title') ?>">
        </div>
        <div class="col-lg-2 m--margin-bottom-20-desktop m--margin-bottom-10-tablet-and-mobile">
            <label for="category">دسته:</label>
            <select class="form-control m-bootstrap-select selectpicker" name="category" id="category">
                <option value="0">همه</option>
                <?php
                $categories = (new Category())->lists();
                foreach ($categories as $category) {
                    echo "<option value='{$category->ID}' " . activeState($category->ID, input('category')) . ">{$category->CATEGORY_NAME}</option>";
                }
                ?>
            </select>
        </div>
        <div class="col-lg-2 m--margin-bottom-20-desktop m--margin-bottom-10-tablet-and-mobile">
            <label for="type">نوع آگهی:</label>
            <select class="form-control m-bootstrap-select selectpicker" name="type" id="type">
                <option value="0">همه</option>
                <?php
                $plans = (new Plan())->all();
                foreach ($plans as $plan) {
                    echo "<option value='{$plan->PLAN_ID}' " . activeState($plan->PLAN_ID, input('type')) . ">{$plan->PLAN_TITLE}</option>";
                }
                ?>
            </select>

        </div>
        <div class="col-lg-2 m--margin-bottom-20-desktop m--margin-bottom-10-tablet-and-mobile">
            <label for="status">وضعیت :</label>
            <select class="form-control m-bootstrap-select selectpicker" name="status" id="type">
                <option value="0">همه</option>
                <option value="2" <?= activeState(input('status'), 2) ?> >فعال</option>
                <option value="1" <?= activeState(input('status'), 1) ?> >غیرفعال</option>
                <option value="5" <?= activeState(input('status'), 5) ?> >در انتظار بررسی</option>
                <option value="3" <?= activeState(input('status'), 3) ?> >رد شده</option>
                <option value="4" <?= activeState(input('status'), 4) ?> >منقضی</option>
                <option value="100" <?= activeState(input('status'), 100) ?> >حذف شده</option>
            </select>
        </div>
        <div class="col-lg-2 m--margin-bottom-20-desktop m--margin-bottom-10-tablet-and-mobile">
            <label for="time">فیلتر زمانی :</label>
            <select class="form-control m-bootstrap-select selectpicker" name="time" id="type" data-col-index="2">
                <option value="0" <?= inputs()->is_set('time') || input('time') == 0 ? "selected" : false ?> >پیش فرض</option>
                <option value="today" <?= activeState(input('time'), 'today') ?> >امروز</option>
                <option value="1" <?= activeState(input('time'), 1) ?> > از 1 ماه قبل</option>
                <option value="3" <?= activeState(input('time'), 3) ?> > از 3 ماه قبل</option>
                <option value="6" <?= activeState(input('time'), 6) ?> > از 6 ماه قبل</option>
                <option value="12" <?= activeState(input('time'), 12) ?> >از یک سال قبل</option>
                <option value="all" <?= activeState(input('time'), 'all') ?> >همه آگهی ها</option>
            </select>
        </div>

        <div class="col-lg-2">
            <label for="sort">مرتب سازی</label>
            <select class="form-control m-bootstrap-select selectpicker" name="sort" id="type">
                <option value="0">پیش فرض</option>
                <option value="views-desc"   <?= activeState(input('sort'), 'views-desc') ?> >بازدیدها نزولی</option>
                <option value="views-asc"    <?= activeState(input('sort'), 'views-asc') ?> >بازدیدها صعودی</option>
                <option value="created-desc" <?= activeState(input('sort'), 'created-desc') ?> >تاریخ ثبت نزولی</option>
                <option value="created-asc"  <?= activeState(input('sort'), 'created-asc') ?> >تاریخ ثبت صعودی</option>
                <option value="updated-desc" <?= activeState(input('sort'), 'updated-desc') ?> >تاریخ ویرایش نزولی</option>
                <option value="updated-asc"  <?= activeState(input('sort'), 'updated-asc') ?> >تاریخ ویرایش صعودی</option>
                <option value="priority-asc"  <?= activeState(input('sort'), 'priority-asc') ?> >اولویت پلان نزولی</option>
                <option value="priority-desc"  <?= activeState(input('sort'), 'priority-desc') ?> >اولویت پلان صعودی</option>
            </select>
        </div>

        <div class="col-lg-3">
            <label for="time">کاربر ثبت کننده</label>
            <select data-remote-load-data
                    data-remote-url="process/ajax_calls.php?action=remote-load-users&type=minimal"
                    name="user"  class="form-control m-input m-select2" dir="rtl">
                <?php
                $user = null;
                if (inputs()->not_empty('user')) {
                    $user = $User->findById(input('user'));
                }
                if ($user) {
                    echo "<option value='{$user->USER_ID}'>{$user->username()}</option>";
                }
                ?>
                <option value="0">همه کاربران</option>
            </select>
        </div>

    </div>

    <div class="m-separator m-separator--dashed"></div>

    <div class="row text-right">
        <div class="col-lg-12">
            <a href="<?= adsRoute() ?>" class="btn btn-secondary m-btn m-btn--icon">
                <span>
                    <i class="la la-close"></i>
                    <span>پاک سازی</span>
                </span>
            </a>
            <button type="submit" class="btn btn-brand m-btn m-btn--icon">
                <span>
                    <i class="la la-search"></i>
                    <span>فیلتر</span>
                </span>
            </button>
        </div>
    </div>

</form>