<?php

use App\CategoryList;
use App\LocationList;
use App\Plan;

?>
<div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
    <div class="m-portlet__body">
        <div class="m-portlet__body form-float-input">

            <div class="form-group form-group--float form-group--icon">
                <input type="text" id="frm_title" name="frm_title" class="form-control" value="<?= input('frm_title') ?>">
                <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                <label for="frm_title"><?php _e('ADS_TITLE') ?></label>
                <p class="help-block"></p>
            </div>

            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="state_id"><?php _e('STATE') ?></label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-map-marker-alt"></i> </span>
                        <select name="frm_states" id="state_id" class="form-control advanced-select" data-location-selector data-changes-map="yes" data-child-selector="#city_id" data-target-type="city" data-map-selector-id="map-convas">
                            <option value="0" disabled selected style="display: none;"><?php _e('CHOOSE') ?></option>
                            <?php
                            $LocationList = new LocationList();
                            /** @var App\Location $state */
                            foreach ($LocationList->states() as $state) {
                                echo "<option value='{$state->id()}' " . activeState(input('frm_states'), $state->id()) . " data-latitude='{$state->latitude}' data-longitude='{$state->longitude}'>{$state->name()}</option>";
                            }
                            ?>
                        </select>
                        <p class="help-block"></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="city_id"><?php _e('CITY') ?></label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-map-marker-alt"></i> </span>
                        <select name="frm_cities" id="city_id" class="form-control advanced-select" data-changes-map="yes" data-map-selector-id="map-convas">
                            <option value="0" selected="selected"><?php _e('CHOOSE') ?></option>
                        </select>
                        <p class="help-block"></p>
                    </div>
                </div>
            </div>

            <div class="form-group form-group--float form-group--icon">
                <textarea name="frm_full_address" id="frm_full_address" class="form-control small"><?= input('frm_full_address') ?></textarea>
                <span class="input-icon-addon top-3"> <i class="fa fa-map-pin"></i> </span>
                <label for="frm_full_address"><?php _e('ADS_ADDRESS') ?></label>
            </div>

            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="select-category"><?php _e('ADS_CATEGORY') ?> </label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-sitemap"></i> </span>
                        <select name="category" id="select-category" data-type="submit" class="form-control advanced-select">
                            <option value="any" disabled selected style="display: none;"><?php _e('CHOOSE') ?></option>
                            <?php
                            $CategoryList = new CategoryList();
                            $categories = $CategoryList->categories();
                            /** @var App\Category $category */
                            foreach ($categories as $category) {
                                echo "<option value='{$category->ID}'>{$category->CATEGORY_NAME}</option>";
                            }
                            ?>
                        </select>

                        <div id="subcategory-placeholder" style="display:none; margin-top: 3px">
                            <select name="subcategory" id="select-subcategory" class="form-control advanced-select" title="frm_subcategory">

                            </select>
                        </div>

                        <div id="subsidiary-placeholder" style="display:none">
                            <select name="subsidiary" id="select-subsidiary" class="form-control advanced-select" title="frm_subsidiary">

                            </select>
                        </div>
                        <p class="help-block" id="category-help-block"></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="frm_plan_type"><?php _e('ADS_PLAN') ?> </label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-trophy"></i> </span>
                        <select name="frm_plan_type" id="frm_plan_type" class="form-control advanced-select">
                            <option value="any" disabled selected style="display: none;"><?php _e('CHOOSE') ?></option>

                            <?php
                            $Plan = new Plan();
                            if (setting('CAN_ADD_SPECIAL_ADS') === "YES") {
                                $plans = $Plan->all();

                                /** @var Plan $plan */
                                foreach ($plans as $plan) {
                                    if ($plan->isFree()) {
                                        echo "<option value='{$plan->ID}' ". activeState($plan->ID, input('frm_plan_type')) ." >{$plan->PLAN_TITLE}</option>";
                                    } else {
                                        echo "<option value='{$plan->ID}' ". activeState($plan->ID, input('frm_plan_type')) ." >{$plan->PLAN_TITLE} (" . showPrice($plan->PLAN_PRICE, true) . ")</option>";
                                    }
                                }
                            } else {
                                $plan = $Plan->findFreePlan();
                                echo "<option value='{$plan->ID}' ". activeState($plan->ID, input('frm_plan_type')) ." >{$plan->PLAN_TITLE}</option>";
                            }
                            ?>
                        </select>
                        <p class="help-block"></p>
                    </div>
                </div>
            </div>

            <div id="search-custom-fields">
                <?php
                if (! empty($custom_fields)) {
                    /** @var App\CustomFields $custom_field */
                    foreach ($custom_fields as $custom_field) {
                        $custom_field->show('register');
                    }
                }
                ?>
            </div>

            <div class="hide-when-custom-has-fields m-form__group row" style="display:none; margin-bottom: 10px;">
                <div class="col-sm-6 col-xs-12 form-div" >
                    <div class="form-group form-group--float form-group--icon has-checkbox-addon" style="margin-bottom: 10px;">
                        <input type="text" id="frm_price" name="frm_price" class="form-control ltr digits-field"
                               value="<?php echo input('frm_price') ?>">
                        <span class="input-icon-addon"><i class="fa fa-money"></i> </span>
                        <label for="frm_price"> &nbsp;<?php echo _e('PRICE', true) . ' (' . setting('CURRENCY_EXHIBITIVE') . ')' ?></label>
                        <div class="digits-divider"></div>
                    </div>
                    <div class="checkbox checkbox-addon">
                        <label for="frm_price_deal">
                            <input type="checkbox" data-text-with-checkbox data-input="#frm_price" name="frm_price_deal" id="frm_price_deal"> <i class="input-helper"></i> <?php _e('DEAL') ?>
                        </label>
                    </div>
                </div>

                <?php if (setting('SUBMIT__ENABLE_DISCOUNT_FIELD') === 'YES') : ?>
                    <div class="col-sm-6 col-xs-12 form-div">
                        <div class="form-group form-group--float form-group--icon">
                            <input type="text" id="frm_discount" name="frm_discount" class="form-control digits-field ltr"
                                   value="<?php echo input('frm_discount') ?>">
                            <span class="input-icon-addon top-3"> <i class="fa fa-handshake-o"></i> </span>
                            <label for="frm_discount"> &nbsp; <?php _e('DISCOUNT') ?> </label>
                        </div>
                    </div>
                <?php endif; ?>
            </div>


            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group select-group--float form-group--float form-group--icon">
                        <label for="frm_user">صاحب آگهی</label>
                        <span class="input-icon-addon top-3"> <i class="fa fa-user"></i> </span>
                        <select name="frm_user" id="frm_user" class="form-control" dir="rtl" data-remote-load-data data-remote-url="process/ajax_calls.php?action=remote-load-users&type=minimal">
                            <option value="<?= currentUser()->USER_ID ?>"><?= currentUser()->publicName() . ' - ' . currentUser()->roleName() ?></option>
                        </select>
                        <p class="help-block"></p>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon">
                        <input type="text" id="frm_mail" name="frm_mail" class="form-control ltr" value="<?= input('frm_mail') ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-envelope"></i> </span>
                        <label for="frm_mail"><?php _e('ADS_OWNER_EMAIL') ?></label>
                    </div>
                </div>
            </div>

            <div class="m-form__group row">
                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon">
                        <input type="text" id="frm_phone" name="frm_phone" class="form-control ltr" value="<?= input('frm_phone') ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-phone"></i> </span>
                        <label for="frm_phone"><?php _e('ADS_OWNER_PHONE') ?></label>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="form-group form-group--float form-group--icon">
                        <input type="text" id="frm_link" name="frm_link" class="form-control ltr" value="<?= input('frm_link') ?>">
                        <span class="input-icon-addon top-3"> <i class="fa fa-external-link-alt"></i> </span>
                        <label for="frm_link"><?php _e('LINK') ?></label>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="frm_description"><h5><?php _e('ADS_DESCRIPTION') ?>:</h5> </label>
                <textarea type="text" name="frm_description" id="frm_description"></textarea>
            </div>

            <div class="form-group select-group--float form-group--float form-group--icon">
                <label for="frm_keywords"><?php _e('TAGS') ?></label>
                <select class="form-control advanced-select-tags" name="frm_keywords[]" id="frm_keywords" multiple="multiple" >

                </select>
                <div id="tags-input-help" class="input-sticky-help tags-help" data-container="body" data-toggle="m-popover" data-placement="top" data-skin="dark" data-content="پس از واردن کردن هر برچسب دکمه Enter را بفشارید"><i class='fa fa-question-circle'></i></div>
            </div>
        </div>
    </div>
</div>