<?php

use Admin\Ads;
use App\Category;
use App\ExpiryEmail;

include 'init.php';

$page_slug = 'expired-email';
include 'check_auth.php';

/**
 * Send Emails
 */
if (input('do') === "send") {
    checkDemoMode();

    $ExpiryEmails = new ExpiryEmail(4);
    $errors = $ExpiryEmails->send();

    if (! empty($errors)) {
        session()->put('SESS_EMAIL_ERR', $errors);
    } else {
        session()->success('ارسال پیام ها با موفقیت انجام شد');
    }

    redirect('refer');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="<?= expireMessagesRoute('email') ?>"
                               class="btn btn-secondary m-btn m-btn--custom m-btn--icon portlet-action-button">
                                <span><i class="la la-arrow-right"></i><span>انصراف</span></span>
                            </a>

                            <?php include 'includes/help_button.php' ?>
                        </div>

                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">

                                <div class="col-lg-12 m-t-40">

                                    <?php
                                    $ExpiryEmails = new ExpiryEmail();
                                    $counts = $ExpiryEmails->count();

                                    if (session()->is_empty('SESS_EMAIL_ERR')) :
                                        if (empty($counts)) :
                                    ?>
                                            <div class="text-center">
                                                <button type="button" class="btn btn-warning btn-outline btn-lg btn-x-large"> هیچ ایمیل انقضای در حال انتظاری برای ارسال وجود ندارد </button>
                                            </div>
                                        <?php else : ?>
                                            <div class="controls" style="text-align:center">
                                                <a href="<?= expireMessagesRoute('email', 'send') ?>" class="btn btn-accent btn-outline m-btn--air btn-lg btn-x-large"> شروع ارسال ایمیل های انقضا ( <?php echo $counts ?> ایمیل ) </a>
                                            </div>
                                        <?php endif; ?>
                                    <?php else : ?>
                                        <div class="controls" style="text-align:center">
                                            ارسال ایمیل های مربوط به آگهی های زیر به دلایل نامعلومی ناموفق بوده است
                                        </div>
                                        <div class='next-line'></div>
                                        <?php
                                        $Ads = new Ads();
                                        foreach (session()->get('SESS_EMAIL_ERR') as $error) {
                                            $ads = $Ads->ads_by_id($error);
                                            echo "
												<div class='alert alert-error'>
													 {$ads->ADS_TITLE} ( شناسه آگهی : {$ads->ADS_ID} ---<i class='icon-arrow-left' style='font-size:8px'></i> ایمیل : {$ads->ADS_OWNER_EMAIL} )
												</div>
											";
                                        }
                                        ?>
                                        <div class="controls" style="text-align:center">
                                            <a href="expire__emails.php?do=sendExpire" class="btn green big size-18">ارسال مجدد ایمیل های انقضای ناموفق ( <?php echo $counts ?> ایمیل ) </a>
                                        </div>
                                        <?php
                                        session()->delete('SESS_EMAIL_ERR');
                                    endif;
                                    ?>



                                </div>

                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

</body>
</html>

