<?php
use App\Coupon;

include 'init.php';

$page_slug = 'coupons-edit';
include 'check_auth.php';


$Coupon = new Coupon();
$coupon = $Coupon->byId(input('id'), false);

if (! $coupon) {
    abort();
}

if (isPost() && token()->check()) {

    include('process/coupon/_edit_coupon.php');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/persianDatepicker/css/persianDatepicker-default.css"/>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="submit-item-form">

                            <?= csrf_field() ?>

                            <!--begin::Portlet-->
                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile" >
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= categoriesRoute() ?>" class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                انصراف
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" name="submit_item" id="submit_item" class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                        <i class="la la-check"></i>ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-7">
                                    <?php include('includes/edit_coupon/_main_fields.php') ?>
                                </div>
                                <div class="col-lg-5">
                                    <?php include('includes/edit_coupon/_status_widgets.php') ?>
                                </div>
                            </div>

                        </form>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
<script src="vendors/persianDatepicker/js/persianDatepicker.min.js"></script>

<script>
    initiateSelect2();
    initiateDatePickers();
</script>
</body>
</html>

