<?php

use App\Comment;

include 'init.php';

$Comment = new Comment();
$comment = $Comment->findById(input('id'));

if (! $comment) {
    abort();
}

$page_slug = ($comment->isForPost()) ? 'comments-edit-post' : 'comments-edit';
include 'check_auth.php';

if (isPost()) {
    checkDemoMode();

    $comment = $Comment->findById(input('id'));

    $data = array(
        'user_id' => input('user_id'),
        'status' => input('status'),
        'text' => input('text'),
    );

    try {
        $comment->update($data);

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="">

                            <!--begin::Portlet-->
                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= commentsRoute(null, null, $comment->type) ?>"
                                               class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                بازگشت
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" name="submit_item" id="submit_item"
                                                        class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                    <i class="la la-check"></i>
                                                    ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-7">

                                    <div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
                                        <div class="m-portlet__body">
                                            <div class="m-portlet__body form-float-input">

                                                <div class="col-xs-12 form-div">
                                                    <div class="form-group form-group--float form-group--icon <?= groupActiveState($comment->text) ?>">
                                                        <textarea name="text" id="text" class="form-control medium"><?= $comment->text ?></textarea>
                                                        <span class="input-icon-addon top-3"> <i class="fa fa-edit"></i> </span>
                                                        <label for="text">متن دیدگاه</label>
                                                        <p class="help-block"></p>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="text">آگهی مربوطه:</label>
                                                        <div><a href="<?= $comment->item()->shortLink() ?>" class="m-badge m-badge--info m-badge--wide" target="_blank"><?= $comment->item()->title() ?></a></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                                <div class="col-lg-5">

                                    <div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" style="margin-top: 30px">
                                        <div class="m-portlet__body">
                                            <div class="m-portlet__body form-float-input">

                                                <div class="form-group select-group--float form-group--float form-group--icon">
                                                    <?php if (! empty($comment->ip)) : ?>
                                                        <div class="m-badge m-badge--info m-badge--wide pull-left">
                                                            <a href="<?= ipLink($comment->ip) ?>" target='blank' style='color:white'>آی پی ثبت کننده دیدگاه:&nbsp; <span class='foreign ltr'><?= $comment->ip ?></a>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>

                                                <div class="form-group select-group--float form-group--float form-group--icon">
                                                    <label for="user_id">صاحب آگهی</label>
                                                    <span class="input-icon-addon top-3"> <i class="fa fa-user"></i> </span>
                                                    <select name="user_id" id="user_id" class="form-control" dir="rtl" data-remote-load-data data-remote-url="process/ajax_calls.php?action=remote-load-users&type=minimal">
                                                        <?php if ($comment->user()) : ?>
                                                            <option value="<?= $comment->user()->USER_ID ?>"><?= $comment->user()->publicName() . ' - ' . $comment->user()->roleName() ?></option>
                                                        <?php endif; ?>
                                                    </select>
                                                    <p class="help-block"></p>
                                                </div>

                                                <div class="form-group select-group--float form-group--float form-group--icon m-t-40">
                                                    <label for="status"><?php _e('STATUS') ?></label>
                                                    <span class="input-icon-addon top-3"> <i class="fa fa-map-marker-alt"></i> </span>
                                                    <select name="status" id="status" class="form-control advanced-select">
                                                        <option value="1" <?= activeState($comment->status, 1) ?>> در انتظار بررسی </option>
                                                        <option value="2" <?= activeState($comment->status, 2) ?>> تایید شده </option>
                                                        <option value="3" <?= activeState($comment->status, 3) ?>>رد شده </option>
                                                        <option value="4" <?= activeState($comment->status, 4) ?>>هرزنامه </option>
                                                    </select>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </form>

                        <!--end::Portlet-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>

    initiateSelect2();
    initiateSelect2Tags();
</script>
</body>
</html>

